#
# TABLE STRUCTURE FOR: attendence_type
#

DROP TABLE IF EXISTS `attendence_type`;

CREATE TABLE `attendence_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `key_value` varchar(50) NOT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Present', '<b class=\"text text-success\">P</b>', 'yes', '2016-06-23 14:11:37', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Late With Excuse', '<b class=\"text text-warning\">E</b>', 'no', '2018-05-29 04:19:48', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Late', '<b class=\"text text-warning\">L</b>', 'yes', '2016-06-23 14:12:28', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'Absent', '<b class=\"text text-danger\">A</b>', 'yes', '2016-10-11 07:35:40', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Holiday', 'H', 'yes', '2016-10-11 07:35:01', '0000-00-00 00:00:00');
INSERT INTO `attendence_type` (`id`, `type`, `key_value`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Half Day', '<b class=\"text text-warning\">F</b>', 'yes', '2016-06-23 14:12:28', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: book_issues
#

DROP TABLE IF EXISTS `book_issues`;

CREATE TABLE `book_issues` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `book_id` int(11) DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `is_returned` int(11) DEFAULT 0,
  `member_id` int(11) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: books
#

DROP TABLE IF EXISTS `books`;

CREATE TABLE `books` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `book_title` varchar(100) NOT NULL,
  `book_no` varchar(50) NOT NULL,
  `isbn_no` varchar(100) NOT NULL,
  `subject` varchar(100) DEFAULT NULL,
  `rack_no` varchar(100) NOT NULL,
  `publish` varchar(100) DEFAULT NULL,
  `author` varchar(100) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `perunitcost` float(10,2) DEFAULT NULL,
  `postdate` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `available` varchar(10) DEFAULT 'yes',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: categories
#

DROP TABLE IF EXISTS `categories`;

CREATE TABLE `categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(100) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Nursery', 'no', '2022-11-24 02:47:11', '0000-00-00 00:00:00');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Primary', 'no', '2022-11-24 02:46:54', '0000-00-00 00:00:00');
INSERT INTO `categories` (`id`, `category`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Secondary', 'no', '2022-11-24 02:47:02', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text NOT NULL,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = students',
  `status` tinyint(1) NOT NULL,
  `header_height` int(11) NOT NULL,
  `content_height` int(11) NOT NULL,
  `footer_height` int(11) NOT NULL,
  `content_width` int(11) NOT NULL,
  `enable_student_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_at`, `updated_at`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_student_image`, `enable_image_height`) VALUES (1, 'Sample Transfer Certificate', 'This is certify that <b>[name]</b> has born on [dob]  <br> and have following details [present_address] [guardian] [created_at] [admission_no] [roll_no] [class] [section] [gender] [admission_date] [category] [cast] [father_name] [mother_name] [religion] [email] [phone] .<br>We wish best of luck for future endeavors.', 'Reff. No.......................', '', 'Date: ___/____/_______', '.................................<br>Authority Sign', '.................................<br>Principal Sign', '.................................<br>Class Teacher Sign', 'sampletc12.png', '2018-09-05 15:47:33', '0000-00-00 00:00:00', 2, 1, 360, 400, 480, 810, 1, 230);


#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `chat_user_one` int(11) NOT NULL,
  `chat_user_two` int(11) NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text DEFAULT NULL,
  `chat_user_id` int(11) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int(11) NOT NULL,
  `is_first` int(1) DEFAULT 0,
  `is_read` int(1) NOT NULL DEFAULT 0,
  `chat_connection_id` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `create_staff_id` int(11) DEFAULT NULL,
  `create_student_id` int(11) DEFAULT NULL,
  `is_active` int(11) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `student_id` (`student_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_student_id` (`create_student_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: class_sections
#

DROP TABLE IF EXISTS `class_sections`;

CREATE TABLE `class_sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `class_id` (`class_id`),
  KEY `section_id` (`section_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 1, 'no', '2022-11-24 04:57:21', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 2, 1, 'no', '2022-11-24 04:57:56', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (3, 3, 1, 'no', '2022-11-24 04:58:07', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (4, 4, 1, 'no', '2022-11-24 04:58:23', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (5, 5, 1, 'no', '2022-11-24 04:59:00', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (6, 6, 1, 'no', '2022-11-24 04:59:11', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (7, 7, 1, 'no', '2022-11-24 04:59:24', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (8, 8, 1, 'no', '2022-11-24 04:59:34', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (9, 9, 1, 'no', '2022-11-24 04:59:48', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (10, 10, 1, 'no', '2022-11-24 04:59:57', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (11, 11, 1, 'no', '2022-11-24 05:00:05', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (12, 12, 1, 'no', '2022-11-24 05:00:20', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (13, 13, 1, 'no', '2022-11-24 05:00:27', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (14, 14, 1, 'no', '2022-12-02 07:28:30', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (15, 13, 2, 'no', '2023-05-03 08:24:13', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (16, 10, 2, 'no', '2023-05-12 08:38:54', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (17, 15, 1, 'no', '2023-12-13 04:28:59', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (18, 15, 2, 'no', '2023-12-13 04:28:59', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (19, 11, 2, 'no', '2023-12-13 04:45:19', '0000-00-00 00:00:00');
INSERT INTO `class_sections` (`id`, `class_id`, `section_id`, `is_active`, `created_at`, `updated_at`) VALUES (20, 12, 2, 'no', '2025-03-07 09:24:00', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: class_teacher
#

DROP TABLE IF EXISTS `class_teacher`;

CREATE TABLE `class_teacher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) NOT NULL,
  `staff_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (1, 10, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (2, 11, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (3, 13, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (4, 1, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (5, 2, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (6, 3, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (7, 4, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (8, 5, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (9, 6, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (10, 7, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (11, 8, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (12, 14, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (13, 13, 2, 2);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (14, 12, 2, 1);
INSERT INTO `class_teacher` (`id`, `class_id`, `staff_id`, `section_id`) VALUES (15, 15, 2, 1);


#
# TABLE STRUCTURE FOR: classes
#

DROP TABLE IF EXISTS `classes`;

CREATE TABLE `classes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class` varchar(60) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'PG', 'no', '2022-11-24 04:57:21', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'NURSERY 1', 'no', '2022-11-24 04:58:39', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'NURSERY 2', 'no', '2022-11-24 04:58:31', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'PRIMARY 1', 'no', '2022-11-24 04:58:23', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'PRIMARY 2', 'no', '2022-11-24 04:59:00', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'PRIMARY 3', 'no', '2022-11-24 04:59:11', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'PRIMARY 4', 'no', '2022-11-24 04:59:24', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'PRIMARY 5', 'no', '2022-11-24 04:59:34', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'PRIMARY 6', 'no', '2022-11-24 04:59:48', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'JSS 1', 'no', '2022-11-24 05:00:12', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'JSS 2', 'no', '2022-11-24 05:00:05', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'JSS 3', 'no', '2022-11-24 05:00:20', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'SS 1', 'no', '2022-11-24 05:00:27', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'NURSERY 3', 'no', '2022-12-09 07:54:46', '0000-00-00 00:00:00');
INSERT INTO `classes` (`id`, `class`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'SS 2', 'no', '2023-12-13 04:28:59', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(15) NOT NULL,
  `source` varchar(15) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(15) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text NOT NULL,
  `image` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `class_id` int(11) DEFAULT NULL,
  `cls_sec_id` int(10) NOT NULL,
  `file` varchar(250) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `department` (`id`, `department_name`, `is_active`) VALUES (1, 'EXAMINATION MANAGEMENT', 'yes');


#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `address` varchar(500) NOT NULL,
  `note` varchar(500) NOT NULL,
  `from_title` varchar(200) NOT NULL,
  `date` varchar(20) NOT NULL,
  `image` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `type` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `is_active`, `created_at`) VALUES (1, 'sendmail', '', '', '', '', '', '', '2017-12-04 17:33:22');


#
# TABLE STRUCTURE FOR: enquiry
#

DROP TABLE IF EXISTS `enquiry`;

CREATE TABLE `enquiry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `address` mediumtext NOT NULL,
  `reference` varchar(20) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(500) NOT NULL,
  `follow_up_date` date NOT NULL,
  `note` mediumtext NOT NULL,
  `source` varchar(50) NOT NULL,
  `email` varchar(50) DEFAULT NULL,
  `assigned` varchar(100) NOT NULL,
  `class` int(11) NOT NULL,
  `no_of_child` varchar(11) DEFAULT NULL,
  `status` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: enquiry_type
#

DROP TABLE IF EXISTS `enquiry_type`;

CREATE TABLE `enquiry_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `enquiry_type` varchar(100) NOT NULL,
  `description` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` varchar(300) NOT NULL,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `is_active` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: exam_ca_label
#

DROP TABLE IF EXISTS `exam_ca_label`;

CREATE TABLE `exam_ca_label` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `section_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `ca_type` varchar(10) NOT NULL,
  `max_mark` varchar(10) NOT NULL,
  `label` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `active` int(1) NOT NULL,
  `last_modified` timestamp NOT NULL DEFAULT current_timestamp(),
  `created` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

#
# TABLE STRUCTURE FOR: exam_result_label
#

DROP TABLE IF EXISTS `exam_result_label`;

CREATE TABLE `exam_result_label` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class_id` int(11) DEFAULT NULL,
  `section_id` int(11) DEFAULT NULL,
  `head_address` varchar(60) DEFAULT NULL,
  `teacher_address` varchar(60) DEFAULT NULL,
  `student_address` varchar(60) DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;

INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (1, 1, 1, 'Head Teacher', 'Class Teacher', 'Pupil', 'no', '2022-12-18 16:06:14', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (2, 13, 2, 'Head Teacher', 'Class Teacher', 'Student', 'no', '2022-12-18 16:26:53', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (3, 16, 1, 'Principal', 'Class Teacher', 'Student', 'no', '2023-04-29 03:11:05', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (4, 14, 1, 'Principal', 'Class Teacher', 'Student', 'no', '2023-04-29 03:11:12', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (5, 13, 1, 'Head Teacher', 'Class Teacher', 'Student', 'no', '2022-12-18 16:27:20', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (6, 12, 1, 'Head Teacher', 'Class Teacher', 'Student', 'no', '2022-12-18 16:27:20', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (7, 11, 1, 'Head Teacher', 'Class Teacher', 'Student', 'no', '2022-12-18 16:27:21', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (8, 10, 1, 'Head Teacher', 'Class Teacher', 'Student', 'no', '2022-12-18 16:27:22', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (9, 9, 1, 'Head Teacher', 'Class Teacher', 'Pupil', 'no', '2022-12-18 16:27:23', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (10, 8, 1, 'Head Teacher', 'Class Teacher', 'Pupil', 'no', '2022-12-18 16:27:24', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (11, 7, 1, 'Head Teacher', 'Class Teacher', 'Pupil', 'no', '2022-12-18 16:27:24', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (12, 6, 1, 'Head Teacher', 'Class Teacher', 'Pupil', 'no', '2022-12-18 16:27:25', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (13, 5, 1, 'Head Teacher', 'Class Teacher', 'Pupil', 'no', '2022-12-18 16:27:26', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (14, 4, 1, 'Head Teacher', 'Class Teacher', 'Pupil', 'no', '2022-12-18 16:27:27', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (15, 3, 1, 'Head Teacher', 'Class Teacher', 'Pupil', 'no', '2022-12-18 16:27:27', '0000-00-00 00:00:00');
INSERT INTO `exam_result_label` (`id`, `class_id`, `section_id`, `head_address`, `teacher_address`, `student_address`, `is_active`, `created_at`, `updated_at`) VALUES (16, 2, 1, 'Head Teacher', 'Class Teacher', 'Pupil', 'no', '2022-12-18 16:27:28', '0000-00-00 00:00:00');


#
# TABLE STRUCTURE FOR: exam_results
#

DROP TABLE IF EXISTS `exam_results`;

CREATE TABLE `exam_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attendence` varchar(10) NOT NULL,
  `exam_schedule_id` int(11) DEFAULT NULL,
  `student_id` int(11) DEFAULT NULL,
  `ca1` float(10,2) DEFAULT NULL,
  `ca2` float(10,2) DEFAULT NULL,
  `ca3` float(10,2) DEFAULT NULL,
  `ca4` float(10,2) DEFAULT NULL,
  `ca5` float(10,2) DEFAULT NULL,
  `ca6` float(10,2) DEFAULT NULL,
  `ca7` float(10,2) DEFAULT NULL,
  `ca8` float(10,2) DEFAULT NULL,
  `ca9` float(10,2) DEFAULT NULL,
  `get_marks` float(10,2) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `exam_schedule_id` (`exam_schedule_id`),
  KEY `student_id` (`student_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21898 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'pre', 13, 188, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'pre', 14, 188, '10.00', '9.00', '10.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'pre', 15, 188, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-15 09:00:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'pre', 16, 188, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'pre', 17, 188, '10.00', '8.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'pre', 18, 188, '7.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'pre', 19, 188, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'pre', 20, 188, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'pre', 21, 188, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'pre', 22, 188, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'pre', 23, 188, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'pre', 24, 188, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'pre', 13, 189, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'pre', 14, 189, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'pre', 15, 189, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'pre', 16, 189, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'pre', 17, 189, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'pre', 18, 189, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'pre', 19, 189, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'pre', 20, 189, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'pre', 21, 189, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'pre', 22, 189, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'pre', 23, 189, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'pre', 24, 189, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'pre', 13, 191, '5.00', '7.00', '8.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'pre', 14, 191, '10.00', '5.00', '5.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'pre', 15, 191, '10.00', '8.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'pre', 16, 191, '10.00', '8.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'pre', 17, 191, '5.00', '7.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'pre', 18, 191, '8.00', '7.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'pre', 19, 191, '10.00', '8.00', '7.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'pre', 20, 191, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2023-01-13 06:02:08', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'pre', 21, 191, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'pre', 22, 191, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'pre', 23, 191, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'pre', 24, 191, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'pre', 13, 192, '5.00', '5.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'pre', 14, 192, '5.00', '4.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-19 00:16:29', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'pre', 15, 192, '10.00', '8.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'pre', 16, 192, '1.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'pre', 17, 192, '5.00', '5.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'pre', 18, 192, '5.00', '4.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'pre', 19, 192, '10.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'pre', 20, 192, '10.00', '10.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'pre', 21, 192, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'pre', 22, 192, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'pre', 23, 192, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'pre', 24, 192, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'ABS', 13, 193, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'ABS', 14, 193, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'ABS', 15, 193, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'ABS', 16, 193, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'ABS', 17, 193, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'ABS', 18, 193, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'ABS', 19, 193, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'ABS', 20, 193, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'ABS', 21, 193, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'ABS', 22, 193, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'ABS', 23, 193, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'ABS', 24, 193, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'pre', 13, 195, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'pre', 14, 195, '10.00', '8.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'pre', 15, 195, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'pre', 16, 195, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'pre', 17, 195, '7.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'pre', 18, 195, '9.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'pre', 19, 195, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'pre', 20, 195, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'pre', 21, 195, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'pre', 22, 195, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'pre', 23, 195, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'pre', 24, 195, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'pre', 13, 210, '6.00', '6.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-19 00:16:29', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'pre', 14, 210, '8.00', '5.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'pre', 15, 210, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'pre', 16, 210, '10.00', '8.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'pre', 17, 210, '5.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (78, 'pre', 18, 210, '8.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (79, 'pre', 19, 210, '10.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (80, 'pre', 20, 210, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (81, 'pre', 21, 210, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (82, 'pre', 22, 210, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (83, 'pre', 23, 210, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (84, 'pre', 24, 210, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (85, 'pre', 13, 199, '8.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (86, 'pre', 14, 199, '8.00', '5.00', '5.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (87, 'pre', 15, 199, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (88, 'pre', 16, 199, '10.00', '8.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (89, 'pre', 17, 199, '5.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (90, 'pre', 18, 199, '5.00', '6.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (91, 'pre', 19, 199, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (92, 'pre', 20, 199, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (93, 'pre', 21, 199, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (94, 'pre', 22, 199, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (95, 'pre', 23, 199, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (96, 'pre', 24, 199, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (97, 'pre', 13, 202, '10.00', '8.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (98, 'pre', 14, 202, '5.00', '5.00', '5.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (99, 'pre', 15, 202, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (100, 'pre', 16, 202, '10.00', '8.00', '8.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (101, 'pre', 17, 202, '7.00', '8.00', '8.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (102, 'pre', 18, 202, '8.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (103, 'pre', 19, 202, '10.00', '8.00', '8.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (104, 'pre', 20, 202, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (105, 'pre', 21, 202, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (106, 'pre', 22, 202, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (107, 'pre', 23, 202, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (108, 'pre', 24, 202, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (109, 'pre', 13, 203, '6.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (110, 'pre', 14, 203, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (111, 'pre', 15, 203, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (112, 'pre', 16, 203, '10.00', '7.00', '7.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (113, 'pre', 17, 203, '8.00', '5.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (114, 'pre', 18, 203, '5.00', '7.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (115, 'pre', 19, 203, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (116, 'pre', 20, 203, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (117, 'pre', 21, 203, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (118, 'pre', 22, 203, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (119, 'pre', 23, 203, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (120, 'pre', 24, 203, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (121, 'pre', 13, 205, '10.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (122, 'pre', 14, 205, '7.00', '6.00', '5.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (123, 'pre', 15, 205, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (124, 'pre', 16, 205, '10.00', '7.00', '7.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (125, 'pre', 17, 205, '10.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (126, 'pre', 18, 205, '8.00', '7.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (127, 'pre', 19, 205, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (128, 'pre', 20, 205, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (129, 'pre', 21, 205, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (130, 'pre', 22, 205, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (131, 'pre', 23, 205, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (132, 'pre', 24, 205, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (133, 'pre', 13, 206, '8.00', '8.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (134, 'pre', 14, 206, '10.00', '8.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (135, 'pre', 15, 206, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (136, 'pre', 16, 206, '10.00', '80.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:00:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (137, 'pre', 17, 206, '5.00', '8.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (138, 'pre', 18, 206, '5.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (139, 'pre', 19, 206, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (140, 'pre', 20, 206, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (141, 'pre', 21, 206, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (142, 'pre', 22, 206, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (143, 'pre', 23, 206, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (144, 'pre', 24, 206, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (145, 'pre', 13, 209, '6.00', '6.00', '6.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '58.00', NULL, 'no', '2022-12-15 11:19:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (146, 'pre', 14, 209, '5.00', '5.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (147, 'pre', 15, 209, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (148, 'pre', 16, 209, '10.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:00:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (149, 'pre', 17, 209, '7.00', '8.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (150, 'pre', 18, 209, '5.00', '7.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (151, 'pre', 19, 209, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (152, 'pre', 20, 209, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (153, 'pre', 21, 209, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (154, 'pre', 22, 209, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (155, 'pre', 23, 209, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (156, 'pre', 24, 209, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (157, 'pre', 13, 213, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (158, 'pre', 14, 213, '10.00', '8.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (159, 'pre', 15, 213, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (160, 'pre', 16, 213, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (161, 'pre', 17, 213, '8.00', '8.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (162, 'pre', 18, 213, '7.00', '9.00', '8.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '59.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (163, 'pre', 19, 213, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (164, 'pre', 20, 213, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (165, 'pre', 21, 213, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (166, 'pre', 22, 213, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (167, 'pre', 23, 213, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (168, 'pre', 24, 213, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (169, 'pre', 13, 215, '10.00', '6.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (170, 'pre', 14, 215, '5.00', '5.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (171, 'pre', 15, 215, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (172, 'pre', 16, 215, '10.00', '8.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (173, 'pre', 17, 215, '8.00', '7.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (174, 'pre', 18, 215, '5.00', '4.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (175, 'pre', 19, 215, '10.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (176, 'pre', 20, 215, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (177, 'pre', 21, 215, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (178, 'pre', 22, 215, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (179, 'pre', 23, 215, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (180, 'pre', 24, 215, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (181, 'pre', 13, 216, '8.00', '8.00', '8.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:00:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (182, 'pre', 14, 216, '4.00', '7.00', '6.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (183, 'pre', 15, 216, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (184, 'pre', 16, 216, '10.00', '8.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (185, 'pre', 17, 216, '5.00', '8.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (186, 'pre', 18, 216, '7.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.54', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (187, 'pre', 19, 216, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (188, 'pre', 20, 216, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (189, 'pre', 21, 216, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (190, 'pre', 22, 216, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (191, 'pre', 23, 216, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (192, 'pre', 24, 216, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (193, 'pre', 13, 218, '8.00', '6.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 02:49:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (194, 'pre', 14, 218, '9.00', '5.00', '5.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (195, 'pre', 15, 218, '10.00', '10.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (196, 'pre', 16, 218, '10.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (197, 'pre', 17, 218, '10.00', '7.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (198, 'pre', 18, 218, '7.00', '6.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '48.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (199, 'pre', 19, 218, '10.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (200, 'pre', 20, 218, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (201, 'pre', 21, 218, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (202, 'pre', 22, 218, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (203, 'pre', 23, 218, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (204, 'pre', 24, 218, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (205, 'pre', 13, 219, '10.00', '8.00', '8.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (206, 'pre', 14, 219, '9.00', '5.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (207, 'pre', 15, 219, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (208, 'pre', 16, 219, '10.00', '7.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (209, 'pre', 17, 219, '8.00', '8.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (210, 'pre', 18, 219, '7.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '59.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (211, 'pre', 19, 219, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (212, 'pre', 20, 219, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (213, 'pre', 21, 219, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (214, 'pre', 22, 219, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (215, 'pre', 23, 219, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (216, 'pre', 24, 219, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (217, 'pre', 13, 221, '7.00', '6.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 02:49:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (218, 'pre', 14, 221, '5.00', '5.00', '5.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '4.00', NULL, 'no', '2022-12-12 02:49:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (219, 'pre', 15, 221, '10.00', '8.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (220, 'pre', 16, 221, '100.00', '7.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (221, 'pre', 17, 221, '8.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (222, 'pre', 18, 221, '5.00', '6.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (223, 'pre', 19, 221, '10.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (224, 'pre', 20, 221, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (225, 'pre', 21, 221, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (226, 'pre', 22, 221, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (227, 'pre', 23, 221, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (228, 'pre', 24, 221, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (229, 'pre', 13, 222, '10.00', '8.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (230, 'pre', 14, 222, '10.00', '7.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:49:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (231, 'pre', 15, 222, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (232, 'pre', 16, 222, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (233, 'pre', 17, 222, '8.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '58.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (234, 'pre', 18, 222, '8.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (235, 'pre', 19, 222, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (236, 'pre', 20, 222, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (237, 'pre', 21, 222, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (238, 'pre', 22, 222, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (239, 'pre', 23, 222, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (240, 'pre', 24, 222, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (241, 'pre', 13, 223, '10.00', '5.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 02:49:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (242, 'pre', 14, 223, '5.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 02:49:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (243, 'pre', 15, 223, '10.00', '8.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (244, 'pre', 16, 223, '10.00', '7.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (245, 'pre', 17, 223, '5.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 05:02:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (246, 'pre', 18, 223, '6.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '29.00', NULL, 'no', '2022-12-12 05:02:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (247, 'pre', 19, 223, '10.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (248, 'pre', 20, 223, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:02:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (249, 'pre', 21, 223, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (250, 'pre', 22, 223, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (251, 'pre', 23, 223, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (252, 'pre', 24, 223, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:07:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (253, 'pre', 1, 150, '10.00', '5.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (254, 'pre', 2, 150, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (255, 'pre', 3, 150, '9.00', '4.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 03:49:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (256, 'pre', 4, 150, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (257, 'pre', 5, 150, '4.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 04:53:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (258, 'pre', 6, 150, '6.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 04:24:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (259, 'pre', 7, 150, '8.00', '4.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '48.00', NULL, 'no', '2022-12-12 04:04:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (260, 'pre', 8, 150, '9.00', '6.00', '5.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 04:12:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (261, 'pre', 9, 150, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (262, 'pre', 10, 150, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (263, 'pre', 11, 150, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (264, 'pre', 12, 150, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (265, 'pre', 1, 164, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (266, 'pre', 2, 164, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (267, 'pre', 3, 164, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (268, 'pre', 4, 164, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (269, 'pre', 5, 164, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (270, 'pre', 6, 164, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-19 00:05:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (271, 'pre', 7, 164, '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 04:04:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (272, 'pre', 8, 164, '8.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 04:12:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (273, 'pre', 9, 164, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (274, 'pre', 10, 164, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (275, 'pre', 11, 164, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (276, 'pre', 12, 164, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (277, 'pre', 1, 167, '3.00', '3.00', '3.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-15 10:19:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (278, 'pre', 2, 167, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (279, 'pre', 3, 167, '9.00', '0.00', '6.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-15 10:19:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (280, 'pre', 4, 167, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (281, 'pre', 5, 167, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (282, 'pre', 6, 167, '10.00', '4.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-12 04:24:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (283, 'pre', 7, 167, '6.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-12 04:24:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (284, 'pre', 8, 167, '5.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-12 04:12:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (285, 'pre', 9, 167, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (286, 'pre', 10, 167, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (287, 'pre', 11, 167, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (288, 'pre', 12, 167, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (289, 'pre', 1, 175, '7.00', '8.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (290, 'pre', 2, 175, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (291, 'pre', 3, 175, '4.00', '8.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 03:49:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (292, 'pre', 4, 175, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (293, 'pre', 5, 175, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (294, 'pre', 6, 175, '7.00', '5.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-12 04:24:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (295, 'pre', 7, 175, '10.00', '8.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-18 15:51:00', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (296, 'pre', 8, 175, '6.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 04:12:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (297, 'pre', 9, 175, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (298, 'pre', 10, 175, '0.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:59:50', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (299, 'pre', 11, 175, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (300, 'pre', 12, 175, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (301, 'pre', 1, 181, '9.00', '4.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 03:37:53', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (302, 'pre', 2, 181, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (303, 'pre', 3, 181, '6.00', '4.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 03:49:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (304, 'pre', 4, 181, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (305, 'pre', 5, 181, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (306, 'pre', 6, 181, '7.00', '4.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 04:24:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (307, 'pre', 7, 181, '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 04:04:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (308, 'pre', 8, 181, '6.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 04:12:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (309, 'pre', 9, 181, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (310, 'pre', 10, 181, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (311, 'pre', 11, 181, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (312, 'pre', 12, 181, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (313, 'ABS', 1, 208, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:53', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (314, 'ABS', 2, 208, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:53', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (315, 'ABS', 3, 208, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:53', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (316, 'ABS', 4, 208, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:53', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (317, 'ABS', 5, 208, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:53', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (318, 'ABS', 6, 208, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:53', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (319, 'ABS', 7, 208, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:53', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (320, 'ABS', 8, 208, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:53', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (321, 'ABS', 9, 208, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:53', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (322, 'ABS', 10, 208, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:53', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (323, 'ABS', 11, 208, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:53', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (324, 'pre', 12, 208, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 02:09:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (325, 'pre', 1, 311, '6.00', '4.00', '4.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 03:37:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (326, 'pre', 2, 311, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (327, 'pre', 3, 311, '3.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 03:49:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (328, 'pre', 4, 311, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (329, 'pre', 5, 311, '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 04:53:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (330, 'pre', 6, 311, '6.00', '6.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 04:24:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (331, 'pre', 7, 311, '40.00', '6.00', '5.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 04:04:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (332, 'pre', 8, 311, '3.00', '5.00', '4.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 04:12:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (333, 'pre', 9, 311, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (334, 'pre', 10, 311, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (335, 'pre', 11, 311, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (336, 'pre', 12, 311, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 03:37:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (337, 'pre', 61, 151, '10.00', '4.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (338, 'pre', 62, 151, '5.00', '6.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 07:00:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (339, 'pre', 63, 151, '10.00', '5.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '48.00', NULL, 'no', '2022-12-12 07:03:53', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (340, 'pre', 64, 151, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (341, 'pre', 65, 151, '4.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 07:00:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (342, 'pre', 66, 151, '3.00', '4.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (343, 'ABS', 67, 151, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-16 03:35:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (344, 'pre', 68, 151, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (345, 'pre', 69, 151, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (346, 'pre', 70, 151, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (347, 'pre', 71, 151, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (348, 'pre', 72, 151, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (349, 'ABS', 61, 152, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (350, 'ABS', 62, 152, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (351, 'ABS', 63, 152, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (352, 'ABS', 64, 152, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (353, 'ABS', 65, 152, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (354, 'ABS', 66, 152, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (355, 'ABS', 67, 152, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (356, 'ABS', 68, 152, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (357, 'ABS', 69, 152, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (358, 'ABS', 70, 152, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (359, 'ABS', 71, 152, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (360, 'pre', 72, 152, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (361, 'pre', 61, 153, '6.00', '5.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (362, 'pre', 62, 153, '5.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (363, 'pre', 63, 153, '8.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:01:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (364, 'pre', 64, 153, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (365, 'pre', 65, 153, '7.00', '8.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 07:51:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (366, 'pre', 66, 153, '5.00', '5.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (367, 'pre', 67, 153, '7.00', '5.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (368, 'pre', 68, 153, '10.00', '5.00', '4.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (369, 'pre', 69, 153, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (370, 'pre', 70, 153, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (371, 'pre', 71, 153, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (372, 'pre', 72, 153, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (373, 'pre', 61, 154, '8.00', '5.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (374, 'pre', 62, 154, '8.00', '5.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (375, 'pre', 63, 154, '6.00', '5.00', '4.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:38:55', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (376, 'pre', 64, 154, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (377, 'pre', 65, 154, '6.00', '5.00', '4.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 07:51:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (378, 'pre', 66, 154, '5.00', '4.00', '5.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (379, 'pre', 67, 154, '5.00', '5.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (380, 'pre', 68, 154, '5.00', '5.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (381, 'pre', 69, 154, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (382, 'pre', 70, 154, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (383, 'pre', 71, 154, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (384, 'pre', 72, 154, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (385, 'pre', 61, 156, '10.00', '6.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (386, 'pre', 62, 156, '5.00', '6.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (387, 'pre', 63, 156, '9.00', '5.00', '5.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '49.00', NULL, 'no', '2022-12-12 12:01:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (388, 'pre', 64, 156, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (389, 'pre', 65, 156, '9.00', '5.00', '5.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '49.00', NULL, 'no', '2022-12-12 07:51:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (390, 'pre', 66, 156, '5.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (391, 'pre', 67, 156, '5.00', '6.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (392, 'pre', 68, 156, '6.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (393, 'pre', 69, 156, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (394, 'pre', 70, 156, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (395, 'pre', 71, 156, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (396, 'pre', 72, 156, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (397, 'pre', 61, 157, '10.00', '6.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '32.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (398, 'pre', 62, 157, '7.00', '7.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (399, 'pre', 63, 157, '5.00', '6.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:38:55', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (400, 'pre', 64, 157, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (401, 'pre', 65, 157, '5.00', '6.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 11:52:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (402, 'pre', 66, 157, '10.00', '6.00', '5.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (403, 'pre', 67, 157, '6.00', '6.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (404, 'pre', 68, 157, '5.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (405, 'pre', 69, 157, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (406, 'pre', 70, 157, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (407, 'pre', 71, 157, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (408, 'pre', 72, 157, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (409, 'pre', 61, 159, '10.00', '8.00', '6.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '43.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (410, 'pre', 62, 159, '6.00', '8.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (411, 'pre', 63, 159, '6.00', '7.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:38:55', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (412, 'pre', 64, 159, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (413, 'pre', 65, 159, '6.00', '7.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 11:52:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (414, 'pre', 66, 159, '10.00', '7.00', '6.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '53.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (415, 'pre', 67, 159, '8.00', '6.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (416, 'pre', 68, 159, '5.00', '8.00', '7.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (417, 'pre', 69, 159, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (418, 'pre', 70, 159, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (419, 'pre', 71, 159, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (420, 'pre', 72, 159, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (421, 'pre', 61, 160, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (422, 'pre', 62, 160, '4.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (423, 'pre', 63, 160, '10.00', '8.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:38:55', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (424, 'pre', 64, 160, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (425, 'pre', 65, 160, '10.00', '8.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 11:52:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (426, 'pre', 66, 160, '9.00', '8.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (427, 'pre', 67, 160, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (428, 'pre', 68, 160, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (429, 'pre', 69, 160, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (430, 'pre', 70, 160, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (431, 'pre', 71, 160, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (432, 'pre', 72, 160, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (433, 'pre', 61, 161, '10.00', '4.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (434, 'pre', 62, 161, '9.00', '4.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (435, 'pre', 63, 161, '4.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:38:55', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (436, 'pre', 64, 161, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (437, 'pre', 65, 161, '4.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 11:52:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (438, 'pre', 66, 161, '7.00', '9.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (439, 'pre', 67, 161, '6.00', '6.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '57.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (440, 'pre', 68, 161, '6.00', '5.00', '5.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (441, 'pre', 69, 161, '6.00', '5.00', '5.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (442, 'pre', 70, 161, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (443, 'pre', 71, 161, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (444, 'pre', 72, 161, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (445, 'pre', 61, 163, '10.00', '8.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (446, 'pre', 62, 163, '10.00', '8.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (447, 'pre', 63, 163, '10.00', '8.00', '7.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:38:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (448, 'pre', 64, 163, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (449, 'pre', 65, 163, '10.00', '8.00', '7.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 11:52:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (450, 'pre', 66, 163, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (451, 'pre', 67, 163, '10.00', '8.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (452, 'pre', 68, 163, '6.00', '8.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (453, 'pre', 69, 163, '6.00', '8.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (454, 'pre', 70, 163, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (455, 'pre', 71, 163, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (456, 'pre', 72, 163, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (457, 'pre', 61, 166, '10.00', '5.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (458, 'pre', 62, 166, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (459, 'pre', 63, 166, '5.00', '4.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-19 00:23:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (460, 'pre', 64, 166, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (461, 'pre', 65, 166, '5.00', '4.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 11:52:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (462, 'pre', 66, 166, '10.00', '5.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (463, 'pre', 67, 166, '5.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (464, 'pre', 68, 166, '5.00', '5.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (465, 'pre', 69, 166, '5.00', '5.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (466, 'pre', 70, 166, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (467, 'pre', 71, 166, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (468, 'pre', 72, 166, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (469, 'pre', 61, 168, '10.00', '5.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '49.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (470, 'pre', 62, 168, '10.00', '6.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '54.00', NULL, 'no', '2022-12-12 06:38:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (471, 'pre', 63, 168, '7.00', '5.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:21:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (472, 'pre', 64, 168, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 07:00:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (473, 'pre', 65, 168, '9.00', '7.00', '6.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 11:52:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (474, 'pre', 66, 168, '8.00', '5.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (475, 'pre', 67, 168, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (476, 'pre', 68, 168, '6.00', '4.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (477, 'pre', 69, 168, '6.00', '4.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (478, 'pre', 70, 168, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (479, 'pre', 71, 168, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (480, 'pre', 72, 168, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (481, 'pre', 61, 170, '10.00', '5.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '34.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (482, 'pre', 62, 170, '10.00', '6.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (483, 'pre', 63, 170, '7.00', '4.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:21:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (484, 'pre', 64, 170, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (485, 'pre', 65, 170, '10.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 07:00:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (486, 'pre', 66, 170, '10.00', '4.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '38.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (487, 'pre', 67, 170, '10.00', '5.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (488, 'pre', 68, 170, '10.00', '5.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (489, 'pre', 69, 170, '10.00', '5.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (490, 'pre', 70, 170, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (491, 'pre', 71, 170, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (492, 'pre', 72, 170, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (493, 'ABS', 61, 171, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (494, 'ABS', 62, 171, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (495, 'ABS', 63, 171, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (496, 'ABS', 64, 171, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (497, 'ABS', 65, 171, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (498, 'ABS', 66, 171, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (499, 'ABS', 67, 171, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (500, 'ABS', 68, 171, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (501, 'ABS', 69, 171, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (502, 'ABS', 70, 171, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (503, 'ABS', 71, 171, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (504, 'pre', 72, 171, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (505, 'pre', 61, 172, '10.00', '6.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (506, 'pre', 62, 172, '4.00', '5.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (507, 'pre', 63, 172, '3.00', '6.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:38:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (508, 'pre', 64, 172, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (509, 'pre', 65, 172, '6.00', '6.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:30:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (510, 'pre', 66, 172, '5.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (511, 'pre', 67, 172, '4.00', '8.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (512, 'pre', 68, 172, '7.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (513, 'pre', 69, 172, '84.00', '5.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (514, 'pre', 70, 172, '7.00', '8.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (515, 'pre', 71, 172, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (516, 'pre', 72, 172, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (517, 'pre', 61, 173, '10.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (518, 'pre', 62, 173, '4.00', '4.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (519, 'pre', 63, 173, '8.00', '5.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 06:38:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (520, 'pre', 64, 173, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (521, 'pre', 65, 173, '6.00', '6.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '57.00', NULL, 'no', '2022-12-12 12:30:50', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (522, 'pre', 66, 173, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (523, 'pre', 67, 173, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (524, 'pre', 68, 173, '10.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (525, 'pre', 69, 173, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (526, 'pre', 70, 173, '8.00', '5.00', '4.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (527, 'pre', 71, 173, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (528, 'pre', 72, 173, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (529, 'pre', 61, 174, '10.00', '7.00', '6.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (530, 'pre', 62, 174, '6.00', '6.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (531, 'pre', 63, 174, '8.00', '6.00', '6.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 06:38:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (532, 'pre', 64, 174, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (533, 'pre', 65, 174, '6.00', '8.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '59.00', NULL, 'no', '2022-12-12 12:30:50', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (534, 'pre', 66, 174, '7.00', '7.00', '6.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (535, 'pre', 67, 174, '7.00', '7.00', '6.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (536, 'pre', 68, 174, '6.00', '6.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (537, 'pre', 69, 174, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (538, 'pre', 70, 174, '7.00', '6.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (539, 'pre', 71, 174, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (540, 'pre', 72, 174, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (541, 'pre', 61, 177, '4.00', '5.00', '4.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (542, 'pre', 62, 177, '0.50', '4.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (543, 'pre', 63, 177, '5.00', '6.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 06:38:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (544, 'pre', 64, 177, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (545, 'pre', 65, 177, '9.00', '5.00', '4.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:30:50', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (546, 'pre', 66, 177, '8.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (547, 'pre', 67, 177, '8.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (548, 'pre', 68, 177, '10.00', '8.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '53.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (549, 'pre', 69, 177, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (550, 'pre', 70, 177, '6.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (551, 'pre', 71, 177, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (552, 'pre', 72, 177, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (553, 'ABS', 61, 178, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (554, 'ABS', 62, 178, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (555, 'ABS', 63, 178, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (556, 'ABS', 64, 178, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (557, 'ABS', 65, 178, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (558, 'ABS', 66, 178, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (559, 'ABS', 67, 178, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (560, 'ABS', 68, 178, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (561, 'ABS', 69, 178, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (562, 'ABS', 70, 178, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (563, 'ABS', 71, 178, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (564, 'pre', 72, 178, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (565, 'pre', 61, 179, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (566, 'pre', 62, 179, '6.00', '8.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (567, 'pre', 63, 179, '9.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:38:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (568, 'pre', 64, 179, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (569, 'pre', 65, 179, '4.00', '8.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:30:50', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (570, 'pre', 66, 179, '7.00', '8.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (571, 'pre', 67, 179, '7.00', '8.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (572, 'pre', 68, 179, '9.00', '8.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (573, 'pre', 69, 179, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (574, 'pre', 70, 179, '6.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (575, 'pre', 71, 179, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (576, 'pre', 72, 179, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (577, 'pre', 61, 180, '4.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (578, 'pre', 62, 180, '4.00', '4.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (579, 'pre', 63, 180, '3.00', '4.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:38:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (580, 'pre', 64, 180, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (581, 'pre', 65, 180, '5.00', '8.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:30:50', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (582, 'pre', 66, 180, '5.00', '4.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (583, 'pre', 67, 180, '0.00', '4.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 13:01:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (584, 'pre', 68, 180, '6.00', '5.00', '4.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (585, 'pre', 69, 180, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (586, 'pre', 70, 180, '7.00', '4.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 15:08:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (587, 'pre', 71, 180, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (588, 'pre', 72, 180, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (589, 'ABS', 61, 182, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (590, 'ABS', 62, 182, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (591, 'ABS', 63, 182, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (592, 'ABS', 64, 182, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (593, 'ABS', 65, 182, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (594, 'ABS', 66, 182, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (595, 'ABS', 67, 182, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (596, 'ABS', 68, 182, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (597, 'ABS', 69, 182, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (598, 'ABS', 70, 182, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (599, 'ABS', 71, 182, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (600, 'pre', 72, 182, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (601, 'pre', 61, 183, '4.00', '5.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (602, 'pre', 62, 183, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (603, 'pre', 63, 183, '7.00', '5.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:38:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (604, 'pre', 64, 183, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (605, 'pre', 65, 183, '7.00', '4.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:30:50', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (606, 'pre', 66, 183, '5.00', '6.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 13:42:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (607, 'pre', 67, 183, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 13:42:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (608, 'pre', 68, 183, '10.00', '6.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (609, 'pre', 69, 183, '0.00', '0.00', '0.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '4.00', NULL, 'no', '2022-12-12 06:38:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (610, 'pre', 70, 183, '8.00', '4.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 15:08:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (611, 'pre', 71, 183, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (612, 'pre', 72, 183, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (613, 'pre', 61, 185, '4.00', '6.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (614, 'pre', 62, 185, '5.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 06:07:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (615, 'pre', 63, 185, '6.00', '50.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '6.00', NULL, 'no', '2022-12-12 06:38:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (616, 'pre', 64, 185, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:14:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (617, 'pre', 65, 185, '7.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:30:50', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (618, 'pre', 66, 185, '8.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 13:42:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (619, 'pre', 67, 185, '8.00', '7.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-16 03:35:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (620, 'pre', 68, 185, '10.00', '6.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 14:43:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (621, 'pre', 69, 185, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (622, 'pre', 70, 185, '7.00', '5.00', '4.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 15:08:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (623, 'pre', 71, 185, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (624, 'pre', 72, 185, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 05:37:21', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (625, 'pre', 138, 310, '5.00', '5.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (626, 'pre', 139, 310, '5.00', '5.00', '5.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (627, 'pre', 140, 310, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (628, 'pre', 141, 310, '10.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (629, 'pre', 142, 310, '5.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (630, 'pre', 143, 310, '6.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (631, 'pre', 144, 310, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (632, 'pre', 145, 310, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (633, 'pre', 146, 310, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (634, 'pre', 147, 310, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (635, 'pre', 148, 310, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (636, 'pre', 149, 310, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (637, 'pre', 138, 187, '5.00', '7.00', '5.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (638, 'pre', 139, 187, '5.00', '5.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (639, 'pre', 140, 187, '10.00', '8.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (640, 'pre', 141, 187, '10.00', '8.00', '7.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (641, 'pre', 142, 187, '8.00', '6.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (642, 'pre', 143, 187, '5.00', '6.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (643, 'pre', 144, 187, '8.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (644, 'pre', 145, 187, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (645, 'pre', 146, 187, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (646, 'pre', 147, 187, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (647, 'pre', 148, 187, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (648, 'pre', 149, 187, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (649, 'pre', 138, 190, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (650, 'pre', 139, 190, '6.00', '9.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (651, 'pre', 140, 190, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (652, 'pre', 141, 190, '8.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (653, 'pre', 142, 190, '8.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (654, 'pre', 143, 190, '6.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (655, 'pre', 144, 190, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (656, 'pre', 145, 190, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (657, 'pre', 146, 190, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (658, 'pre', 147, 190, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (659, 'pre', 148, 190, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (660, 'pre', 149, 190, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (661, 'pre', 138, 196, '4.00', '8.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (662, 'pre', 139, 196, '8.00', '5.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (663, 'pre', 140, 196, '5.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (664, 'pre', 141, 196, '10.00', '8.00', '8.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (665, 'pre', 142, 196, '10.00', '8.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (666, 'pre', 143, 196, '8.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (667, 'pre', 144, 196, '5.00', '8.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (668, 'pre', 145, 196, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (669, 'pre', 146, 196, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (670, 'pre', 147, 196, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (671, 'pre', 148, 196, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (672, 'pre', 149, 196, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (673, 'pre', 138, 197, '5.00', '5.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (674, 'pre', 139, 197, '8.00', '5.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (675, 'pre', 140, 197, '5.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (676, 'pre', 141, 197, '10.00', '7.00', '8.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (677, 'pre', 142, 197, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (678, 'pre', 143, 197, '5.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (679, 'pre', 144, 197, '10.00', '8.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (680, 'pre', 145, 197, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (681, 'pre', 146, 197, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (682, 'pre', 147, 197, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (683, 'pre', 148, 197, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (684, 'pre', 149, 197, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (685, 'pre', 138, 198, '10.00', '8.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (686, 'pre', 139, 198, '5.00', '7.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (687, 'pre', 140, 198, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (688, 'pre', 141, 198, '8.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (689, 'pre', 142, 198, '5.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (690, 'pre', 143, 198, '5.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '59.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (691, 'pre', 144, 198, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (692, 'pre', 145, 198, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (693, 'pre', 146, 198, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (694, 'pre', 147, 198, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (695, 'pre', 148, 198, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (696, 'pre', 149, 198, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (697, 'pre', 138, 200, '5.00', '5.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (698, 'pre', 139, 200, '8.00', '5.00', '5.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (699, 'pre', 140, 200, '5.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (700, 'pre', 141, 200, '10.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (701, 'pre', 142, 200, '8.00', '6.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (702, 'pre', 143, 200, '5.00', '6.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (703, 'pre', 144, 200, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (704, 'pre', 145, 200, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (705, 'pre', 146, 200, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (706, 'pre', 147, 200, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (707, 'pre', 148, 200, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (708, 'pre', 149, 200, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (709, 'pre', 138, 201, '6.00', '5.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (710, 'pre', 139, 201, '5.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (711, 'pre', 140, 201, '5.00', '7.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (712, 'pre', 141, 201, '8.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (713, 'pre', 142, 201, '10.00', '8.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (714, 'pre', 143, 201, '7.00', '8.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (715, 'pre', 144, 201, '8.00', '7.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (716, 'pre', 145, 201, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (717, 'pre', 146, 201, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (718, 'pre', 147, 201, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (719, 'pre', 148, 201, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (720, 'pre', 149, 201, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (721, 'pre', 138, 212, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (722, 'pre', 139, 212, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (723, 'pre', 140, 212, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (724, 'pre', 141, 212, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (725, 'pre', 142, 212, '7.00', '8.00', '8.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (726, 'pre', 143, 212, '9.00', '9.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '59.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (727, 'pre', 144, 212, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (728, 'pre', 145, 212, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (729, 'pre', 146, 212, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (730, 'pre', 147, 212, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (731, 'pre', 148, 212, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (732, 'pre', 149, 212, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 06:51:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (733, 'pre', 25, 224, '10.00', '10.00', '9.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 07:50:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (734, 'pre', 26, 224, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (735, 'pre', 27, 224, '10.00', '10.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (736, 'pre', 28, 224, '10.00', '10.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '54.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (737, 'pre', 29, 224, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 22:10:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (738, 'pre', 30, 224, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 22:10:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (739, 'pre', 31, 224, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (740, 'pre', 32, 224, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (741, 'pre', 33, 224, '6.00', '9.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (742, 'pre', 34, 224, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (743, 'pre', 35, 224, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (744, 'pre', 36, 224, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (745, 'pre', 25, 226, '10.00', '10.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 07:50:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (746, 'pre', 26, 226, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (747, 'pre', 27, 226, '7.00', '7.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (748, 'pre', 28, 226, '10.00', '10.00', '4.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (749, 'pre', 29, 226, '7.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 22:10:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (750, 'pre', 30, 226, '7.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 22:10:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (751, 'pre', 31, 226, '7.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (752, 'pre', 32, 226, '7.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (753, 'pre', 33, 226, '8.00', '7.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (754, 'pre', 34, 226, '10.00', '6.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (755, 'pre', 35, 226, '10.00', '10.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (756, 'pre', 36, 226, '7.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (757, 'pre', 25, 227, '10.00', '10.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 07:50:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (758, 'pre', 26, 227, '7.00', '7.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (759, 'pre', 27, 227, '10.00', '10.00', '6.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (760, 'pre', 28, 227, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (761, 'pre', 29, 227, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '24.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (762, 'pre', 30, 227, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '24.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (763, 'pre', 31, 227, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '24.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (764, 'pre', 32, 227, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '24.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (765, 'pre', 33, 227, '6.00', '8.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (766, 'pre', 34, 227, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (767, 'pre', 35, 227, '10.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (768, 'pre', 36, 227, '8.00', '8.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (769, 'pre', 25, 229, '10.00', '10.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 07:50:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (770, 'pre', 26, 229, '7.00', '5.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (771, 'pre', 27, 229, '7.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (772, 'pre', 28, 229, '7.00', '8.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (773, 'pre', 29, 229, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (774, 'pre', 30, 229, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (775, 'pre', 31, 229, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (776, 'pre', 32, 229, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (777, 'pre', 33, 229, '5.00', '8.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (778, 'pre', 34, 229, '10.00', '6.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (779, 'pre', 35, 229, '10.00', '10.00', '9.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (780, 'pre', 36, 229, '10.00', '8.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (781, 'pre', 25, 230, '10.00', '10.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '54.00', NULL, 'no', '2022-12-12 07:50:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (782, 'pre', 26, 230, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (783, 'pre', 27, 230, '10.00', '10.00', '4.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (784, 'pre', 28, 230, '6.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (785, 'pre', 29, 230, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (786, 'pre', 30, 230, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (787, 'pre', 31, 230, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (788, 'pre', 32, 230, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (789, 'pre', 33, 230, '9.00', '9.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (790, 'pre', 34, 230, '10.00', '6.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (791, 'pre', 35, 230, '10.00', '10.00', '9.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (792, 'pre', 36, 230, '10.00', '10.00', '9.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (793, 'pre', 25, 231, '10.00', '10.00', '5.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 07:50:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (794, 'pre', 26, 231, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (795, 'pre', 27, 231, '7.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (796, 'pre', 28, 231, '10.00', '10.00', '10.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (797, 'pre', 29, 231, '10.00', '9.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (798, 'pre', 30, 231, '10.00', '9.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (799, 'pre', 31, 231, '10.00', '9.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (800, 'pre', 32, 231, '10.00', '9.00', '8.00', '60.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:49:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (801, 'pre', 33, 231, '7.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (802, 'pre', 34, 231, '10.00', '10.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (803, 'pre', 35, 231, '10.00', '10.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (804, 'pre', 36, 231, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (805, 'pre', 25, 232, '10.00', '10.00', '5.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 07:50:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (806, 'pre', 26, 232, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (807, 'pre', 27, 232, '7.00', '7.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (808, 'pre', 28, 232, '10.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (809, 'pre', 29, 232, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (810, 'pre', 30, 232, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (811, 'pre', 31, 232, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (812, 'pre', 32, 232, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (813, 'pre', 33, 232, '8.00', '8.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (814, 'pre', 34, 232, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (815, 'pre', 35, 232, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (816, 'pre', 36, 232, '8.00', '8.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (817, 'pre', 25, 233, '10.00', '10.00', '3.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 07:50:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (818, 'pre', 26, 233, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (819, 'pre', 27, 233, '10.00', '10.00', '10.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (820, 'pre', 28, 233, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '54.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (821, 'pre', 29, 233, '10.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '24.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (822, 'pre', 30, 233, '10.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '24.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (823, 'pre', 31, 233, '10.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '24.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (824, 'pre', 32, 233, '10.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '24.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (825, 'pre', 33, 233, '8.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '34.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (826, 'pre', 34, 233, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (827, 'pre', 35, 233, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (828, 'pre', 36, 233, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (829, 'pre', 25, 234, '10.00', '10.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 07:50:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (830, 'pre', 26, 234, '8.00', '8.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (831, 'pre', 27, 234, '10.00', '10.00', '4.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (832, 'pre', 28, 234, '10.00', '10.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (833, 'pre', 29, 234, '6.00', '6.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (834, 'pre', 30, 234, '6.00', '6.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (835, 'pre', 31, 234, '6.00', '6.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (836, 'pre', 32, 234, '6.00', '6.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (837, 'pre', 33, 234, '9.00', '9.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (838, 'pre', 34, 234, '10.00', '9.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-18 18:33:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (839, 'pre', 35, 234, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (840, 'pre', 36, 234, '8.00', '8.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (841, 'pre', 25, 236, '6.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 07:50:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (842, 'pre', 26, 236, '8.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (843, 'pre', 27, 236, '10.00', '10.00', '3.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (844, 'pre', 28, 236, '10.00', '10.00', '8.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (845, 'pre', 29, 236, '4.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (846, 'pre', 30, 236, '4.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (847, 'pre', 31, 236, '4.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (848, 'pre', 32, 236, '4.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (849, 'pre', 33, 236, '8.00', '9.00', '9.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (850, 'pre', 34, 236, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (851, 'pre', 35, 236, '10.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (852, 'pre', 36, 236, '10.00', '10.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (853, 'pre', 25, 237, '10.00', '9.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '57.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (854, 'pre', 26, 237, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '53.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (855, 'pre', 27, 237, '7.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '53.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (856, 'pre', 28, 237, '10.00', '10.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (857, 'pre', 29, 237, '8.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (858, 'pre', 30, 237, '8.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (859, 'pre', 31, 237, '8.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (860, 'pre', 32, 237, '8.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (861, 'pre', 33, 237, '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (862, 'pre', 34, 237, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (863, 'pre', 35, 237, '10.00', '10.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (864, 'pre', 36, 237, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (865, 'ABS', 25, 238, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (866, 'ABS', 26, 238, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (867, 'ABS', 27, 238, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (868, 'ABS', 28, 238, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (869, 'ABS', 29, 238, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (870, 'ABS', 30, 238, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (871, 'ABS', 31, 238, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (872, 'ABS', 32, 238, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (873, 'ABS', 33, 238, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (874, 'ABS', 34, 238, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (875, 'ABS', 35, 238, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (876, 'ABS', 36, 238, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (877, 'pre', 25, 240, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (878, 'pre', 26, 240, '8.00', '8.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (879, 'pre', 27, 240, '10.00', '10.00', '4.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (880, 'pre', 28, 240, '10.00', '7.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '54.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (881, 'pre', 29, 240, '7.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (882, 'pre', 30, 240, '7.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (883, 'pre', 31, 240, '7.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (884, 'pre', 32, 240, '7.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (885, 'pre', 33, 240, '9.00', '9.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '38.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (886, 'pre', 34, 240, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (887, 'pre', 35, 240, '10.00', '10.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (888, 'pre', 36, 240, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (889, 'pre', 25, 241, '10.00', '10.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (890, 'pre', 26, 241, '9.00', '9.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (891, 'pre', 27, 241, '7.00', '7.00', '3.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (892, 'pre', 28, 241, '10.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '32.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (893, 'pre', 29, 241, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (894, 'pre', 30, 241, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (895, 'pre', 31, 241, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (896, 'pre', 32, 241, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (897, 'pre', 33, 241, '6.00', '6.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (898, 'pre', 34, 241, '10.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '48.00', NULL, 'no', '2022-12-12 12:30:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (899, 'pre', 35, 241, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (900, 'pre', 36, 241, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (901, 'pre', 25, 242, '10.00', '10.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (902, 'pre', 26, 242, '8.00', '8.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (903, 'pre', 27, 242, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (904, 'pre', 28, 242, '10.00', '7.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (905, 'pre', 29, 242, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (906, 'pre', 30, 242, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (907, 'pre', 31, 242, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (908, 'pre', 32, 242, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-19 03:20:22', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (909, 'ABS', 33, 242, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-12 12:30:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (910, 'pre', 34, 242, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-12 12:30:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (911, 'pre', 35, 242, '10.00', '10.00', '9.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (912, 'pre', 36, 242, '6.00', '4.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (913, 'pre', 25, 243, '10.00', '9.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (914, 'pre', 26, 243, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (915, 'pre', 27, 243, '10.00', '10.00', '3.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 10:17:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (916, 'pre', 28, 243, '10.00', '10.00', '8.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (917, 'pre', 29, 243, '8.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (918, 'pre', 30, 243, '8.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (919, 'pre', 31, 243, '8.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (920, 'pre', 32, 243, '8.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (921, 'pre', 33, 243, '6.00', '2.00', '2.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-12 12:30:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (922, 'pre', 34, 243, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:30:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (923, 'pre', 35, 243, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (924, 'pre', 36, 243, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (925, 'pre', 25, 244, '10.00', '6.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-19 04:49:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (926, 'pre', 26, 244, '8.00', '8.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 10:04:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (927, 'pre', 27, 244, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-12 10:17:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (928, 'pre', 28, 244, '10.00', '10.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:05:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (929, 'pre', 29, 244, '7.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '43.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (930, 'pre', 30, 244, '7.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '43.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (931, 'pre', 31, 244, '7.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '43.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (932, 'pre', 32, 244, '7.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '43.00', NULL, 'no', '2022-12-12 23:24:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (933, 'pre', 33, 244, '5.00', '2.00', '2.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-12 12:30:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (934, 'pre', 34, 244, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:30:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (935, 'pre', 35, 244, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (936, 'pre', 36, 244, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-12 12:59:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (937, 'pre', 97, 124, '5.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '31.00', NULL, 'no', '2022-12-13 05:00:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (938, 'pre', 98, 124, '10.00', '4.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-18 17:15:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (939, 'pre', 99, 124, '5.00', '5.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 05:00:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (940, 'pre', 100, 124, '5.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-13 05:00:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (941, 'pre', 101, 124, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '28.00', NULL, 'no', '2022-12-13 05:00:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (942, 'pre', 102, 124, '5.00', '5.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 05:00:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (943, 'pre', 103, 124, '7.00', '10.00', '10.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 05:00:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (944, 'pre', 104, 124, '5.00', '5.00', '5.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-13 05:00:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (945, 'pre', 105, 124, '7.00', '9.00', '9.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 05:00:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (946, 'pre', 106, 124, '6.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:07:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (947, 'pre', 107, 124, '6.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 06:11:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (948, 'pre', 108, 124, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 06:11:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (949, 'pre', 109, 124, '9.00', '8.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 06:11:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (950, 'ABS', 97, 130, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 06:31:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (951, 'ABS', 98, 130, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 06:31:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (952, 'ABS', 99, 130, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 06:31:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (953, 'ABS', 100, 130, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 06:31:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (954, 'ABS', 101, 130, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 06:31:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (955, 'ABS', 102, 130, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (956, 'ABS', 103, 130, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (957, 'ABS', 104, 130, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (958, 'ABS', 105, 130, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (959, 'ABS', 106, 130, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (960, 'pre', 107, 130, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 05:00:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (961, 'pre', 108, 130, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 05:00:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (962, 'pre', 109, 130, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 05:00:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (963, 'pre', 97, 133, '6.00', '8.00', '4.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (964, 'pre', 98, 133, '9.00', '6.00', '5.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (965, 'pre', 99, 133, '4.00', '3.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '12.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (966, 'pre', 100, 133, '5.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (967, 'pre', 101, 133, '5.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (968, 'pre', 102, 133, '2.00', '2.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '12.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (969, 'pre', 103, 133, '5.00', '5.00', '5.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (970, 'pre', 104, 133, '4.00', '5.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (971, 'pre', 105, 133, '5.00', '7.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (972, 'pre', 106, 133, '4.00', '9.00', '9.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (973, 'pre', 107, 133, '4.00', '9.00', '9.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (974, 'pre', 108, 133, '9.00', '6.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (975, 'pre', 109, 133, '8.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 06:31:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (976, 'pre', 97, 137, '5.00', '10.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-13 06:53:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (977, 'pre', 98, 137, '8.00', '6.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 06:53:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (978, 'pre', 99, 137, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 06:53:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (979, 'pre', 100, 137, '5.00', '10.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-13 06:53:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (980, 'pre', 101, 137, '9.00', '10.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 06:53:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (981, 'pre', 102, 137, '8.00', '10.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 06:53:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (982, 'pre', 103, 137, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '13.00', NULL, 'no', '2022-12-13 06:53:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (983, 'pre', 104, 137, '5.00', '5.00', '5.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '32.00', NULL, 'no', '2022-12-13 06:53:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (984, 'pre', 105, 137, '5.00', '5.00', '5.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 06:53:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (985, 'pre', 106, 137, '4.00', '9.00', '7.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 06:53:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (986, 'pre', 107, 137, '10.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '43.00', NULL, 'no', '2022-12-13 06:53:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (987, 'pre', 108, 137, '10.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 06:53:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (988, 'pre', 109, 137, '5.00', '5.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-13 06:53:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (989, 'pre', 97, 138, '3.00', '4.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 07:27:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (990, 'pre', 98, 138, '10.00', '4.00', '6.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:27:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (991, 'pre', 99, 138, '4.00', '5.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:27:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (992, 'pre', 100, 138, '9.00', '10.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:27:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (993, 'pre', 101, 138, '4.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-15 11:45:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (994, 'pre', 102, 138, '4.00', '5.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 07:27:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (995, 'pre', 103, 138, '10.00', '10.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 07:27:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (996, 'pre', 104, 138, '4.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:27:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (997, 'pre', 105, 138, '2.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 07:27:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (998, 'pre', 106, 138, '5.00', '4.00', '3.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '43.00', NULL, 'no', '2022-12-13 07:27:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (999, 'pre', 107, 138, '8.00', '7.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:27:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1000, 'pre', 108, 138, '9.00', '6.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 07:27:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1001, 'pre', 109, 138, '8.00', '5.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 07:27:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1002, 'pre', 97, 155, '3.00', '4.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 07:48:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1003, 'pre', 98, 155, '10.00', '7.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-13 07:48:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1004, 'pre', 99, 155, '3.00', '2.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:48:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1005, 'pre', 100, 155, '5.00', '9.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 07:48:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1006, 'pre', 101, 155, '9.00', '10.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 07:48:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1007, 'pre', 102, 155, '2.00', '3.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 07:48:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1008, 'pre', 103, 155, '10.00', '10.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '41.00', NULL, 'no', '2022-12-13 07:48:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1009, 'pre', 104, 155, '6.00', '2.00', '2.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:48:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1010, 'pre', 105, 155, '0.00', '4.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '14.00', NULL, 'no', '2022-12-13 07:48:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1011, 'pre', 106, 155, '5.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 07:48:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1012, 'pre', 107, 155, '8.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 07:48:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1013, 'pre', 108, 155, '10.00', '8.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:48:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1014, 'pre', 109, 155, '5.00', '5.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 07:48:07', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1015, 'pre', 97, 158, '5.00', '6.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-13 08:05:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1016, 'pre', 98, 158, '10.00', '5.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 08:05:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1017, 'pre', 99, 158, '5.00', '6.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '8.00', NULL, 'no', '2022-12-13 08:05:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1018, 'pre', 100, 158, '5.00', '10.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-13 08:05:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1019, 'pre', 101, 158, '5.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-13 08:05:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1020, 'pre', 102, 158, '5.00', '6.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '8.00', NULL, 'no', '2022-12-13 08:05:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1021, 'pre', 103, 158, '7.00', '2.00', '3.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 08:05:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1022, 'pre', 104, 158, '6.00', '2.00', '2.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 08:05:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1023, 'pre', 105, 158, '4.00', '4.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '14.00', NULL, 'no', '2022-12-13 08:05:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1024, 'pre', 106, 158, '5.00', '5.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-13 08:05:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1025, 'pre', 107, 158, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:05:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1026, 'pre', 108, 158, '5.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '28.00', NULL, 'no', '2022-12-13 08:05:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1027, 'pre', 109, 158, '5.00', '5.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '12.00', NULL, 'no', '2022-12-13 08:05:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1028, 'pre', 97, 162, '5.00', '10.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-13 08:33:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1029, 'pre', 98, 162, '9.00', '2.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:33:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1030, 'pre', 99, 162, '4.00', '4.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '5.00', NULL, 'no', '2022-12-13 08:33:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1031, 'pre', 100, 162, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 05:00:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1032, 'pre', 101, 162, '8.00', '10.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '48.00', NULL, 'no', '2022-12-13 08:33:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1033, 'pre', 102, 162, '8.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 08:33:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1034, 'pre', 103, 162, '4.00', '5.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '5.00', NULL, 'no', '2022-12-13 08:33:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1035, 'pre', 104, 162, '5.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:33:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1036, 'pre', 105, 162, '6.00', '0.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:33:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1037, 'pre', 106, 162, '5.00', '2.00', '2.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 08:33:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1038, 'pre', 107, 162, '3.00', '4.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 08:33:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1039, 'pre', 108, 162, '9.00', '2.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '48.00', NULL, 'no', '2022-12-13 08:33:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1040, 'pre', 109, 162, '5.00', '5.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-13 08:33:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1041, 'pre', 97, 165, '2.00', '4.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 09:04:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1042, 'pre', 98, 165, '9.00', '4.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 09:04:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1043, 'pre', 99, 165, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 05:00:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1044, 'pre', 100, 165, '8.00', '8.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '48.00', NULL, 'no', '2022-12-13 09:04:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1045, 'pre', 101, 165, '8.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 09:04:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1046, 'ABS', 102, 165, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 09:04:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1047, 'pre', 103, 165, '6.00', '7.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-13 09:04:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1048, 'pre', 104, 165, '7.00', '2.00', '2.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 09:04:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1049, 'pre', 105, 165, '6.00', '0.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 09:04:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1050, 'pre', 106, 165, '10.00', '9.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 09:04:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1051, 'pre', 107, 165, '10.00', '6.00', '6.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 09:04:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1052, 'pre', 108, 165, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '57.00', NULL, 'no', '2022-12-13 09:04:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1053, 'pre', 109, 165, '6.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 09:04:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1054, 'pre', 97, 169, '7.00', '10.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 10:29:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1055, 'pre', 98, 169, '10.00', '6.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-18 17:15:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1056, 'pre', 99, 169, '5.00', '5.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '48.00', NULL, 'no', '2022-12-13 10:29:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1057, 'pre', 100, 169, '5.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-13 10:29:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1058, 'pre', 101, 169, '7.00', '10.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '33.00', NULL, 'no', '2022-12-13 10:29:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1059, 'pre', 102, 169, '5.00', '5.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '32.00', NULL, 'no', '2022-12-13 10:29:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1060, 'pre', 103, 169, '6.00', '10.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2023-01-11 04:27:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1061, 'pre', 104, 169, '4.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2023-01-11 03:45:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1062, 'pre', 105, 169, '8.00', '8.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 10:29:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1063, 'pre', 106, 169, '10.00', '9.00', '9.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '33.00', NULL, 'no', '2022-12-13 10:29:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1064, 'pre', 107, 169, '4.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 10:29:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1065, 'pre', 108, 169, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 10:29:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1066, 'pre', 109, 169, '5.00', '5.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-13 10:29:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1067, 'pre', 97, 176, '3.00', '5.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 10:46:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1068, 'pre', 98, 176, '10.00', '6.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 10:46:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1069, 'pre', 99, 176, '5.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 10:46:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1070, 'pre', 100, 176, '5.00', '7.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 10:46:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1071, 'pre', 101, 176, '5.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 10:46:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1072, 'pre', 102, 176, '5.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-13 10:46:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1073, 'pre', 103, 176, '6.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-13 10:46:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1074, 'pre', 104, 176, '4.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 10:46:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1075, 'pre', 105, 176, '3.00', '4.00', '3.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 10:46:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1076, 'pre', 106, 176, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 10:46:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1077, 'pre', 107, 176, '4.00', '6.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '39.00', NULL, 'no', '2022-12-13 10:46:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1078, 'pre', 108, 176, '10.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 10:46:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1079, 'pre', 109, 176, '5.00', '6.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '13.00', NULL, 'no', '2022-12-13 10:46:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1080, 'pre', 97, 184, '8.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 11:36:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1081, 'pre', 98, 184, '10.00', '6.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-13 11:36:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1082, 'pre', 99, 184, '5.00', '8.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '54.00', NULL, 'no', '2022-12-13 11:36:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1083, 'pre', 100, 184, '5.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:36:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1084, 'pre', 101, 184, '10.00', '10.00', '10.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-13 11:36:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1085, 'pre', 102, 184, '8.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '48.00', NULL, 'no', '2022-12-13 11:36:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1086, 'pre', 103, 184, '6.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-13 11:36:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1087, 'pre', 104, 184, '4.00', '10.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 11:36:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1088, 'pre', 105, 184, '6.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 11:36:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1089, 'pre', 106, 184, '4.00', '9.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:36:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1090, 'pre', 107, 184, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2023-01-11 03:55:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1091, 'pre', 108, 184, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 11:36:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1092, 'pre', 109, 184, '9.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '39.00', NULL, 'no', '2022-12-13 11:36:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1093, 'pre', 97, 186, '7.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:07:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1094, 'pre', 98, 186, '6.00', '10.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-13 12:07:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1095, 'pre', 99, 186, '5.00', '5.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 12:07:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1096, 'pre', 100, 186, '9.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:07:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1097, 'pre', 101, 186, '10.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 12:07:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1098, 'pre', 102, 186, '5.00', '5.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-13 12:07:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1099, 'pre', 103, 186, '4.00', '5.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-13 12:07:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1100, 'pre', 104, 186, '10.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:07:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1101, 'pre', 105, 186, '10.00', '10.00', '8.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:07:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1102, 'pre', 106, 186, '8.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:07:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1103, 'pre', 107, 186, '8.00', '9.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:07:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1104, 'pre', 108, 186, '10.00', '4.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 12:07:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1105, 'pre', 109, 186, '7.00', '7.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 12:07:24', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1106, 'pre', 97, 194, '5.00', '10.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:25:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1107, 'pre', 98, 194, '9.00', '7.00', '3.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 12:25:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1108, 'pre', 99, 194, '4.00', '5.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '4.00', NULL, 'no', '2022-12-13 12:25:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1109, 'pre', 100, 194, '9.00', '10.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 12:25:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1110, 'pre', 101, 194, '5.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 12:25:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1111, 'pre', 102, 194, '5.00', '2.00', '2.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '8.00', NULL, 'no', '2022-12-13 12:25:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1112, 'pre', 103, 194, '6.00', '5.00', '3.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-13 12:25:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1113, 'pre', 104, 194, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 12:25:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1114, 'pre', 105, 194, '10.00', '10.00', '8.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:25:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1115, 'pre', 106, 194, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 12:25:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1116, 'pre', 107, 194, '2.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:25:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1117, 'pre', 108, 194, '9.00', '6.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 12:25:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1118, 'pre', 109, 194, '8.00', '7.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:25:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1119, 'pre', 97, 204, '5.00', '5.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-13 12:42:00', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1120, 'pre', 98, 204, '9.00', '6.00', '4.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-13 12:42:00', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1121, 'pre', 99, 204, '4.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-18 17:15:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1122, 'pre', 100, 204, '3.00', '4.00', '10.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 12:42:00', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1123, 'pre', 101, 204, '10.00', '10.00', '10.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-13 12:42:00', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1124, 'pre', 102, 204, '4.00', '4.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-13 12:42:00', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1125, 'pre', 103, 204, '4.00', '10.00', '10.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '51.00', NULL, 'no', '2022-12-13 12:42:00', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1126, 'pre', 104, 204, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-18 17:15:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1127, 'pre', 105, 204, '8.00', '5.00', '5.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:42:00', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1128, 'pre', 106, 204, '10.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 12:42:00', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1129, 'pre', 107, 204, '2.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 12:42:00', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1130, 'pre', 108, 204, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 12:42:00', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1131, 'pre', 109, 204, '5.00', '5.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:42:00', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1132, 'pre', 97, 207, '4.00', '7.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 16:59:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1133, 'pre', 98, 207, '10.00', '5.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-13 16:59:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1134, 'pre', 99, 207, '5.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 16:59:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1135, 'pre', 100, 207, '4.00', '10.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 16:59:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1136, 'pre', 101, 207, '5.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '34.00', NULL, 'no', '2022-12-13 16:59:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1137, 'pre', 102, 207, '6.00', '5.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '51.00', NULL, 'no', '2022-12-13 16:59:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1138, 'pre', 103, 207, '6.00', '10.00', '10.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 16:59:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1139, 'pre', 104, 207, '4.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 16:59:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1140, 'pre', 105, 207, '4.00', '10.00', '7.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 16:59:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1141, 'pre', 106, 207, '7.00', '4.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 16:59:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1142, 'pre', 107, 207, '8.00', '8.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 16:59:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1143, 'pre', 108, 207, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '57.00', NULL, 'no', '2022-12-13 16:59:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1144, 'pre', 109, 207, '4.00', '5.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 16:59:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1145, 'pre', 97, 211, '5.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-13 17:18:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1146, 'pre', 98, 211, '10.00', '5.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '49.00', NULL, 'no', '2022-12-13 17:18:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1147, 'pre', 99, 211, '5.00', '5.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 17:18:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1148, 'pre', 100, 211, '9.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 17:18:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1149, 'pre', 101, 211, '6.00', '10.00', '10.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 17:18:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1150, 'pre', 102, 211, '5.00', '5.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 17:18:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1151, 'pre', 103, 211, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 17:18:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1152, 'pre', 104, 211, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 17:18:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1153, 'pre', 105, 211, '5.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '57.00', NULL, 'no', '2022-12-13 17:18:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1154, 'pre', 106, 211, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-13 17:18:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1155, 'pre', 107, 211, '10.00', '9.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 17:18:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1156, 'pre', 108, 211, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 17:18:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1157, 'pre', 109, 211, '5.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-13 17:18:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1158, 'pre', 97, 214, '3.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 17:30:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1159, 'pre', 98, 214, '10.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 17:30:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1160, 'pre', 99, 214, '5.00', '5.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 17:30:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1161, 'pre', 100, 214, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 17:30:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1162, 'pre', 101, 214, '4.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 17:30:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1163, 'pre', 102, 214, '5.00', '5.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 17:30:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1164, 'pre', 103, 214, '6.00', '5.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 17:30:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1165, 'pre', 104, 214, '10.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 17:30:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1166, 'pre', 105, 214, '5.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '57.00', NULL, 'no', '2022-12-13 17:30:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1167, 'pre', 106, 214, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-13 17:30:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1168, 'pre', 107, 214, '2.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 17:30:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1169, 'pre', 108, 214, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 17:30:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1170, 'pre', 109, 214, '5.00', '10.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '38.00', NULL, 'no', '2022-12-13 17:30:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1171, 'pre', 97, 217, '3.00', '10.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 17:45:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1172, 'pre', 98, 217, '10.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-13 17:45:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1173, 'pre', 99, 217, '5.00', '5.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-13 17:45:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1174, 'pre', 100, 217, '6.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 17:45:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1175, 'pre', 101, 217, '6.00', '10.00', '10.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 17:45:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1176, 'pre', 102, 217, '5.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-13 17:45:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1177, 'pre', 103, 217, '6.00', '10.00', '10.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 17:45:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1178, 'pre', 104, 217, '8.00', '10.00', '5.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 17:45:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1179, 'pre', 105, 217, '10.00', '10.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 17:45:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1180, 'pre', 106, 217, '10.00', '8.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 17:45:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1181, 'pre', 107, 217, '4.00', '8.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 17:45:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1182, 'pre', 108, 217, '9.00', '6.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 17:45:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1183, 'pre', 109, 217, '5.00', '10.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '28.00', NULL, 'no', '2022-12-13 17:45:23', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1184, 'pre', 97, 220, '6.00', '10.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 17:58:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1185, 'pre', 98, 220, '8.00', '2.00', '2.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '39.00', NULL, 'no', '2022-12-13 17:58:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1186, 'pre', 99, 220, '5.00', '4.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '7.00', NULL, 'no', '2022-12-13 17:58:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1187, 'pre', 100, 220, '5.00', '10.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 17:58:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1188, 'pre', 101, 220, '5.00', '10.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 17:58:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1189, 'pre', 102, 220, '5.00', '4.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '7.00', NULL, 'no', '2022-12-13 17:58:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1190, 'pre', 103, 220, '6.00', '5.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 17:58:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1191, 'pre', 104, 220, '4.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 17:58:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1192, 'pre', 105, 220, '10.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 17:58:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1193, 'pre', 106, 220, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 17:58:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1194, 'pre', 107, 220, '5.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 17:58:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1195, 'pre', 108, 220, '9.00', '4.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 17:58:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1196, 'pre', 109, 220, '5.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-13 17:58:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1197, 'pre', 97, 225, '4.00', '7.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 23:14:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1198, 'pre', 98, 225, '10.00', '6.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 23:14:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1199, 'pre', 99, 225, '2.00', '2.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 23:14:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1200, 'pre', 100, 225, '5.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 23:14:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1201, 'pre', 101, 225, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-13 23:14:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1202, 'pre', 102, 225, '2.00', '2.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 23:14:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1203, 'pre', 103, 225, '6.00', '10.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-13 23:14:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1204, 'pre', 104, 225, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 23:14:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1205, 'pre', 105, 225, '8.00', '8.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 23:14:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1206, 'pre', 106, 225, '10.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '41.00', NULL, 'no', '2022-12-13 23:14:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1207, 'pre', 107, 225, '10.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '41.00', NULL, 'no', '2022-12-13 23:14:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1208, 'pre', 108, 225, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 23:14:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1209, 'pre', 109, 225, '8.00', '9.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '28.00', NULL, 'no', '2022-12-13 23:14:09', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1210, 'pre', 97, 228, '4.00', '7.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 23:27:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1211, 'pre', 98, 228, '9.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 23:27:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1212, 'pre', 99, 228, '5.00', '5.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '48.00', NULL, 'no', '2022-12-13 23:27:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1213, 'pre', 100, 228, '9.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 23:27:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1214, 'pre', 101, 228, '4.00', '10.00', '10.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 23:27:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1215, 'pre', 102, 228, '5.00', '5.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '43.00', NULL, 'no', '2022-12-13 23:27:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1216, 'pre', 103, 228, '8.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 23:27:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1217, 'pre', 104, 228, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-13 23:27:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1218, 'pre', 105, 228, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 23:27:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1219, 'pre', 106, 228, '8.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 23:27:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1220, 'pre', 107, 228, '8.00', '9.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 23:27:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1221, 'pre', 108, 228, '10.00', '8.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 23:27:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1222, 'pre', 109, 228, '5.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-13 23:27:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1223, 'pre', 97, 235, '5.00', '5.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-13 23:41:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1224, 'pre', 98, 235, '9.00', '3.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 23:41:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1225, 'pre', 99, 235, '6.00', '6.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '48.00', NULL, 'no', '2022-12-13 23:41:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1226, 'pre', 100, 235, '2.00', '10.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 23:41:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1227, 'pre', 101, 235, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-13 23:41:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1228, 'pre', 102, 235, '6.00', '6.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '9.00', NULL, 'no', '2022-12-13 23:41:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1229, 'pre', 103, 235, '3.00', '2.00', '3.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 23:41:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1230, 'pre', 104, 235, '6.00', '2.00', '2.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '24.00', NULL, 'no', '2022-12-13 23:41:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1231, 'pre', 105, 235, '5.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 23:41:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1232, 'pre', 106, 235, '5.00', '5.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 23:41:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1233, 'pre', 107, 235, '5.00', '2.00', '3.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-13 23:41:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1234, 'pre', 108, 235, '10.00', '8.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 23:41:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1235, 'pre', 109, 235, '5.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '28.00', NULL, 'no', '2022-12-13 23:41:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1236, 'pre', 97, 239, '5.00', '6.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-14 00:27:15', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1237, 'pre', 98, 239, '9.00', '5.00', '3.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 00:27:15', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1238, 'pre', 99, 239, '5.00', '5.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '7.00', NULL, 'no', '2022-12-14 00:27:15', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1239, 'pre', 100, 239, '5.00', '9.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 00:27:15', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1240, 'pre', 101, 239, '6.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 00:27:15', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1241, 'pre', 102, 239, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 00:27:15', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1242, 'pre', 103, 239, '7.00', '10.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 00:27:15', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1243, 'pre', 104, 239, '7.00', '10.00', '5.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 00:27:15', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1244, 'pre', 105, 239, '4.00', '4.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 00:27:15', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1245, 'pre', 106, 239, '10.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 00:27:15', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1246, 'pre', 107, 239, '10.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 00:27:15', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1247, 'pre', 108, 239, '10.00', '7.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 00:27:15', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1248, 'pre', 109, 239, '5.00', '6.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '13.00', NULL, 'no', '2022-12-14 00:27:15', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1249, 'pre', 97, 246, '5.00', '8.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-14 01:19:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1250, 'pre', 98, 246, '9.00', '4.00', '3.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:19:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1251, 'pre', 99, 246, '4.00', '5.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '5.00', NULL, 'no', '2022-12-14 01:19:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1252, 'pre', 100, 246, '2.00', '6.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 01:19:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1253, 'pre', 101, 246, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-14 01:19:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1254, 'pre', 102, 246, '4.00', '5.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '7.00', NULL, 'no', '2022-12-14 01:19:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1255, 'pre', 103, 246, '7.00', '7.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 01:19:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1256, 'pre', 104, 246, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 01:19:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1257, 'pre', 105, 246, '5.00', '4.00', '4.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 01:19:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1258, 'pre', 106, 246, '5.00', '4.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-14 01:19:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1259, 'pre', 107, 246, '2.00', '2.00', '3.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-14 01:19:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1260, 'pre', 108, 246, '10.00', '7.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 01:19:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1261, 'pre', 109, 246, '5.00', '10.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 01:19:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1262, 'ABS', 97, 245, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1263, 'ABS', 98, 245, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1264, 'ABS', 99, 245, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1265, 'ABS', 100, 245, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1266, 'ABS', 101, 245, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1267, 'ABS', 102, 245, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1268, 'ABS', 103, 245, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1269, 'ABS', 104, 245, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1270, 'ABS', 105, 245, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1271, 'ABS', 106, 245, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1272, 'ABS', 107, 245, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1273, 'ABS', 108, 245, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1274, 'ABS', 109, 245, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1275, 'pre', 97, 248, '5.00', '8.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 01:32:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1276, 'pre', 98, 248, '10.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 01:32:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1277, 'pre', 99, 248, '6.00', '6.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 01:32:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1278, 'pre', 100, 248, '4.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:32:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1279, 'pre', 101, 248, '3.00', '10.00', '10.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 01:32:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1280, 'pre', 102, 248, '6.00', '6.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-14 01:32:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1281, 'pre', 103, 248, '9.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 01:32:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1282, 'pre', 104, 248, '10.00', '10.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '41.00', NULL, 'no', '2022-12-14 01:32:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1283, 'pre', 105, 248, '8.00', '9.00', '9.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 01:32:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1284, 'pre', 106, 248, '10.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:32:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1285, 'pre', 107, 248, '8.00', '8.00', '7.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 01:32:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1286, 'pre', 108, 248, '10.00', '7.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 01:32:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1287, 'pre', 109, 248, '5.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '28.00', NULL, 'no', '2022-12-14 01:32:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1288, 'pre', 97, 249, '5.00', '10.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1289, 'pre', 98, 249, '10.00', '6.00', '3.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1290, 'pre', 99, 249, '6.00', '6.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '2.00', NULL, 'no', '2022-12-14 01:49:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1291, 'pre', 100, 249, '4.00', '9.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 01:49:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1292, 'pre', 101, 249, '8.00', '10.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:49:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1293, 'pre', 102, 249, '2.00', '3.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '2.00', NULL, 'no', '2022-12-14 01:49:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1294, 'pre', 103, 249, '10.00', '5.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 01:49:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1295, 'pre', 104, 249, '5.00', '5.00', '2.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-14 01:49:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1296, 'pre', 105, 249, '8.00', '7.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 01:49:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1297, 'pre', 106, 249, '6.00', '4.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:49:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1298, 'pre', 107, 249, '8.00', '5.00', '5.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:49:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1299, 'pre', 108, 249, '9.00', '6.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-14 01:49:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1300, 'pre', 109, 249, '8.00', '5.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 01:49:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1301, 'pre', 97, 252, '2.00', '5.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 12:35:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1302, 'pre', 98, 252, '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 12:35:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1303, 'ABS', 99, 252, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 12:35:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1304, 'pre', 100, 252, '2.00', '9.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 12:35:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1305, 'pre', 101, 252, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 12:35:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1306, 'ABS', 102, 252, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 12:35:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1307, 'pre', 103, 252, '4.00', '10.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 12:35:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1308, 'pre', 104, 252, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 12:35:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1309, 'pre', 105, 252, '0.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 12:35:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1310, 'pre', 106, 252, '7.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 12:35:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1311, 'pre', 107, 252, '5.00', '8.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 12:35:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1312, 'pre', 108, 252, '10.00', '7.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 12:35:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1313, 'pre', 109, 252, '5.00', '5.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-14 12:35:10', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1314, 'pre', 97, 253, '5.00', '6.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-14 02:15:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1315, 'pre', 98, 253, '10.00', '4.00', '1.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 02:15:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1316, 'pre', 99, 253, '5.00', '7.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '12.00', NULL, 'no', '2022-12-14 02:15:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1317, 'pre', 100, 253, '4.00', '7.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 02:15:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1318, 'pre', 101, 253, '5.00', '2.00', '3.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 02:15:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1319, 'pre', 102, 253, '5.00', '7.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '12.00', NULL, 'no', '2022-12-14 02:15:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1320, 'pre', 103, 253, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 02:15:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1321, 'pre', 104, 253, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 02:15:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1322, 'pre', 105, 253, '3.00', '4.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 02:15:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1323, 'pre', 106, 253, '5.00', '2.00', '2.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 02:15:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1324, 'pre', 107, 253, '10.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '41.00', NULL, 'no', '2022-12-14 02:15:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1325, 'pre', 108, 253, '5.00', '4.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 02:15:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1326, 'pre', 109, 253, '7.00', '5.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 02:15:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1327, 'pre', 97, 251, '2.00', '5.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 12:01:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1328, 'pre', 98, 251, '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 12:01:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1329, 'ABS', 99, 251, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 12:01:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1330, 'pre', 100, 251, '2.00', '9.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 12:01:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1331, 'pre', 101, 251, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 12:01:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1332, 'ABS', 102, 251, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 12:01:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1333, 'pre', 103, 251, '4.00', '10.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 12:01:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1334, 'pre', 104, 251, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 12:01:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1335, 'pre', 105, 251, '0.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 12:01:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1336, 'pre', 106, 251, '7.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 12:01:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1337, 'pre', 107, 251, '5.00', '8.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 12:01:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1338, 'pre', 108, 251, '10.00', '7.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 12:01:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1339, 'pre', 109, 251, '5.00', '5.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-14 12:01:57', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1340, 'pre', 97, 257, '5.00', '7.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 12:18:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1341, 'pre', 98, 257, '10.00', '7.00', '6.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 12:18:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1342, 'pre', 99, 257, '5.00', '5.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 12:18:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1343, 'pre', 100, 257, '8.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 12:18:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1344, 'pre', 101, 257, '10.00', '10.00', '10.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-14 12:18:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1345, 'pre', 102, 257, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 12:18:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1346, 'pre', 103, 257, '8.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 12:18:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1347, 'pre', 104, 257, '8.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 12:18:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1348, 'pre', 105, 257, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 12:18:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1349, 'pre', 106, 257, '10.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-14 12:18:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1350, 'pre', 107, 257, '6.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '54.00', NULL, 'no', '2022-12-14 12:18:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1351, 'pre', 108, 257, '10.00', '9.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '53.00', NULL, 'no', '2022-12-14 12:18:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1352, 'pre', 109, 257, '6.00', '6.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 12:18:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1353, 'pre', 97, 271, '2.00', '10.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 13:55:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1354, 'pre', 98, 271, '8.00', '6.00', '7.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 13:55:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1355, 'pre', 99, 271, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '4.00', NULL, 'no', '2022-12-14 13:55:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1356, 'pre', 100, 271, '3.00', '10.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 13:55:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1357, 'pre', 101, 271, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 13:55:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1358, 'pre', 102, 271, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '5.00', NULL, 'no', '2022-12-14 13:55:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1359, 'pre', 103, 271, '10.00', '7.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 13:55:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1360, 'pre', 104, 271, '8.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 13:55:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1361, 'pre', 105, 271, '10.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 13:55:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1362, 'pre', 106, 271, '9.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 13:55:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1363, 'pre', 107, 271, '6.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 13:55:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1364, 'pre', 108, 271, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 13:55:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1365, 'pre', 109, 271, '5.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-14 13:55:14', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1366, 'pre', 97, 275, '5.00', '4.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 14:11:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1367, 'pre', 98, 275, '10.00', '3.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:11:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1368, 'pre', 99, 275, '4.00', '3.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-14 14:11:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1369, 'pre', 100, 275, '5.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 14:11:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1370, 'pre', 101, 275, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 14:11:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1371, 'pre', 102, 275, '3.00', '4.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '8.00', NULL, 'no', '2022-12-14 14:11:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1372, 'pre', 103, 275, '7.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 14:11:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1373, 'pre', 104, 275, '4.00', '5.00', '0.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 14:11:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1374, 'pre', 105, 275, '2.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 14:11:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1375, 'pre', 106, 275, '5.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 14:11:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1376, 'pre', 107, 275, '3.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:11:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1377, 'pre', 108, 275, '9.00', '4.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:11:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1378, 'pre', 109, 275, '5.00', '6.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '17.00', NULL, 'no', '2022-12-14 14:11:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1379, 'pre', 97, 279, '5.00', '4.00', '3.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '12.00', NULL, 'no', '2022-12-14 15:15:22', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1380, 'pre', 98, 279, '10.00', '6.00', '5.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-14 15:15:22', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1381, 'pre', 99, 279, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '11.00', NULL, 'no', '2022-12-14 15:15:22', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1382, 'pre', 100, 279, '4.00', '9.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 15:15:22', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1383, 'pre', 101, 279, '5.00', '10.00', '10.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:15:22', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1384, 'pre', 102, 279, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '11.00', NULL, 'no', '2022-12-14 15:15:22', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1385, 'pre', 103, 279, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-14 15:15:22', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1386, 'pre', 104, 279, '5.00', '5.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 15:15:22', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1387, 'pre', 105, 279, '7.00', '4.00', '4.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:15:22', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1388, 'pre', 106, 279, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 15:15:22', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1389, 'pre', 107, 279, '2.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2023-01-11 04:12:35', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1390, 'pre', 108, 279, '9.00', '4.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 15:15:22', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1391, 'pre', 109, 279, '5.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:15:22', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1392, 'pre', 97, 284, '2.00', '7.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 15:28:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1393, 'pre', 98, 284, '10.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '53.00', NULL, 'no', '2022-12-14 15:28:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1394, 'pre', 99, 284, '5.00', '8.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '39.00', NULL, 'no', '2022-12-14 15:28:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1395, 'pre', 100, 284, '5.00', '10.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 15:28:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1396, 'pre', 101, 284, '5.00', '10.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:28:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1397, 'pre', 102, 284, '8.00', '5.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:28:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1398, 'pre', 103, 284, '10.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-14 15:28:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1399, 'pre', 104, 284, '10.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-14 15:28:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1400, 'pre', 105, 284, '10.00', '9.00', '9.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 15:28:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1401, 'pre', 106, 284, '8.00', '8.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 15:28:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1402, 'pre', 107, 284, '2.00', '9.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 15:28:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1403, 'pre', 108, 284, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 15:28:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1404, 'pre', 109, 284, '7.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:28:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1405, 'pre', 97, 288, '5.00', '4.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-14 21:50:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1406, 'pre', 98, 288, '7.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '33.00', NULL, 'no', '2022-12-14 21:50:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1407, 'pre', 99, 288, '4.00', '4.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '6.00', NULL, 'no', '2022-12-14 21:50:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1408, 'pre', 100, 288, '5.00', '6.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '17.00', NULL, 'no', '2022-12-14 21:50:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1409, 'pre', 101, 288, '5.00', '5.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '12.00', NULL, 'no', '2022-12-14 21:50:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1410, 'pre', 102, 288, '4.00', '4.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '6.00', NULL, 'no', '2022-12-14 21:50:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1411, 'pre', 103, 288, '9.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 21:50:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1412, 'pre', 104, 288, '4.00', '5.00', '2.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 21:50:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1413, 'pre', 105, 288, '4.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 21:50:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1414, 'pre', 106, 288, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 21:50:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1415, 'pre', 107, 288, '5.00', '6.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 21:50:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1416, 'pre', 108, 288, '9.00', '6.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-14 21:50:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1417, 'pre', 109, 288, '5.00', '10.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-14 21:50:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1418, 'pre', 97, 289, '6.00', '6.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-14 22:14:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1419, 'pre', 98, 289, '6.00', '8.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 22:14:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1420, 'pre', 99, 289, '6.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-14 22:14:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1421, 'pre', 100, 289, '7.00', '5.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 22:14:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1422, 'pre', 101, 289, '4.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 22:14:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1423, 'pre', 102, 289, '5.00', '4.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-14 22:14:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1424, 'pre', 103, 289, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 05:01:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1425, 'pre', 104, 289, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 05:01:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1426, 'pre', 105, 289, '5.00', '2.00', '3.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '8.00', NULL, 'no', '2022-12-14 22:14:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1427, 'pre', 106, 289, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 05:01:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1428, 'pre', 107, 289, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 05:01:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1429, 'pre', 108, 289, '9.00', '6.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 22:14:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1430, 'pre', 109, 289, '7.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 22:17:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1431, 'pre', 97, 294, '5.00', '8.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-14 22:32:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1432, 'pre', 98, 294, '7.00', '10.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '33.00', NULL, 'no', '2022-12-14 22:32:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1433, 'pre', 99, 294, '5.00', '4.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-14 22:32:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1434, 'pre', 100, 294, '2.00', '10.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 22:32:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1435, 'pre', 101, 294, '4.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 22:32:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1436, 'pre', 102, 294, '5.00', '4.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-14 22:32:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1437, 'pre', 103, 294, '9.00', '10.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 22:32:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1438, 'pre', 104, 294, '5.00', '5.00', '2.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 22:32:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1439, 'pre', 105, 294, '5.00', '8.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 22:32:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1440, 'pre', 106, 294, '6.00', '2.00', '3.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 22:32:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1441, 'pre', 107, 294, '10.00', '6.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 22:32:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1442, 'pre', 108, 294, '10.00', '6.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 22:32:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1443, 'pre', 109, 294, '3.00', '7.00', '6.00', '20.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 22:32:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1444, 'pre', 97, 296, '5.00', '4.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-14 22:44:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1445, 'pre', 98, 296, '5.00', '10.00', '6.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-14 22:44:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1446, 'pre', 99, 296, '2.00', '3.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '3.00', NULL, 'no', '2022-12-14 22:44:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1447, 'pre', 100, 296, '5.00', '5.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 22:44:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1448, 'pre', 101, 296, '5.00', '5.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-14 22:44:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1449, 'pre', 102, 296, '2.00', '3.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '3.00', NULL, 'no', '2022-12-14 22:44:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1450, 'pre', 103, 296, '8.00', '2.00', '3.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 22:44:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1451, 'pre', 104, 296, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '17.00', NULL, 'no', '2022-12-14 22:44:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1452, 'pre', 105, 296, '5.00', '4.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-14 22:44:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1453, 'pre', 106, 296, '2.00', '2.00', '2.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 22:44:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1454, 'pre', 107, 296, '8.00', '6.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 22:44:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1455, 'pre', 108, 296, '10.00', '8.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 22:44:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1456, 'pre', 109, 296, '5.00', '8.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-14 22:44:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1457, 'pre', 97, 297, '5.00', '6.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '17.00', NULL, 'no', '2022-12-14 22:58:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1458, 'pre', 98, 297, '5.00', '9.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 22:58:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1459, 'pre', 99, 297, '3.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '2.00', NULL, 'no', '2022-12-14 22:58:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1460, 'pre', 100, 297, '5.00', '10.00', '4.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 22:58:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1461, 'pre', 101, 297, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-14 22:58:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1462, 'pre', 102, 297, '3.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '2.00', NULL, 'no', '2022-12-14 22:58:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1463, 'pre', 103, 297, '5.00', '7.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 22:58:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1464, 'pre', 104, 297, '5.00', '5.00', '2.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-14 22:58:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1465, 'pre', 105, 297, '5.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-14 22:58:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1466, 'pre', 106, 297, '5.00', '4.00', '2.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-14 22:58:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1467, 'pre', 107, 297, '5.00', '6.00', '7.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 22:58:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1468, 'pre', 108, 297, '10.00', '8.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-14 22:58:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1469, 'pre', 109, 297, '8.00', '5.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 22:58:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1470, 'pre', 97, 298, '5.00', '4.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-14 23:17:08', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1471, 'pre', 98, 298, '9.00', '10.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 23:17:08', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1472, 'pre', 99, 298, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '7.00', NULL, 'no', '2022-12-14 23:17:08', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1473, 'pre', 100, 298, '10.00', '10.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '41.00', NULL, 'no', '2022-12-14 23:17:08', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1474, 'pre', 101, 298, '8.00', '10.00', '5.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 23:17:08', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1475, 'pre', 102, 298, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 23:17:08', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1476, 'pre', 103, 298, '10.00', '10.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 23:17:08', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1477, 'pre', 104, 298, '10.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '41.00', NULL, 'no', '2022-12-14 23:17:08', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1478, 'pre', 105, 298, '5.00', '8.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-14 23:17:08', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1479, 'pre', 106, 298, '4.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 23:17:08', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1480, 'pre', 107, 298, '8.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 23:17:08', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1481, 'pre', 108, 298, '10.00', '6.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 23:17:08', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1482, 'pre', 109, 298, '5.00', '7.00', '5.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-14 23:17:08', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1483, 'pre', 97, 299, '5.00', '4.00', '6.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '12.00', NULL, 'no', '2022-12-14 23:29:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1484, 'pre', 98, 299, '4.00', '6.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 23:29:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1485, 'ABS', 99, 299, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 23:29:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1486, 'pre', 100, 299, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 05:01:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1487, 'pre', 101, 299, '3.00', '6.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 23:29:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1488, 'pre', 102, 299, '5.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-14 23:29:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1489, 'ABS', 103, 299, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 23:29:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1490, 'pre', 104, 299, '5.00', '5.00', '2.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '17.00', NULL, 'no', '2022-12-14 23:29:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1491, 'pre', 105, 299, '5.00', '4.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-14 23:29:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1492, 'pre', 106, 299, '5.00', '2.00', '2.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '12.00', NULL, 'no', '2022-12-14 23:29:58', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1493, 'pre', 107, 299, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 05:01:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1494, 'pre', 108, 299, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 05:01:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1495, 'pre', 109, 299, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 05:01:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1496, 'pre', 37, 247, '10.00', '4.00', '4.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 05:01:55', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1497, 'pre', 38, 247, '10.00', '8.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-13 05:01:55', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1498, 'pre', 39, 247, '10.00', '10.00', '10.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1499, 'pre', 40, 247, '8.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1500, 'pre', 41, 247, '9.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1501, 'pre', 42, 247, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1502, 'pre', 43, 247, '9.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 06:41:35', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1503, 'pre', 44, 247, '9.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 06:41:35', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1504, 'pre', 45, 247, '6.00', '4.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1505, 'pre', 46, 247, '10.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1506, 'pre', 47, 247, '10.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1507, 'pre', 48, 247, '8.00', '8.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1508, 'pre', 37, 254, '10.00', '10.00', '8.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 05:01:55', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1509, 'pre', 38, 254, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 05:01:55', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1510, 'pre', 39, 254, '10.00', '10.00', '8.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1511, 'pre', 40, 254, '7.00', '7.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1512, 'pre', 41, 254, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1513, 'pre', 42, 254, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1514, 'pre', 43, 254, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 06:41:35', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1515, 'pre', 44, 254, '10.00', '5.00', '0.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 06:41:35', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1516, 'pre', 45, 254, '9.00', '8.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1517, 'pre', 46, 254, '10.00', '10.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1518, 'pre', 47, 254, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1519, 'pre', 48, 254, '8.00', '8.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1520, 'pre', 37, 255, '10.00', '10.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 05:01:55', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1521, 'pre', 38, 255, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 05:01:55', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1522, 'pre', 39, 255, '10.00', '10.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1523, 'pre', 40, 255, '8.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1524, 'pre', 41, 255, '8.00', '8.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1525, 'pre', 42, 255, '8.00', '8.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 06:41:35', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1526, 'pre', 43, 255, '8.00', '8.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 06:41:35', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1527, 'pre', 44, 255, '8.00', '8.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1528, 'pre', 45, 255, '8.00', '8.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1529, 'pre', 46, 255, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1530, 'pre', 47, 255, '10.00', '10.00', '9.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1531, 'pre', 48, 255, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1532, 'pre', 37, 256, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 05:01:55', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1533, 'pre', 38, 256, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 05:01:55', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1534, 'pre', 39, 256, '10.00', '10.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1535, 'pre', 40, 256, '7.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '64.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1536, 'pre', 41, 256, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1537, 'pre', 42, 256, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1538, 'pre', 43, 256, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1539, 'pre', 44, 256, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1540, 'pre', 45, 256, '10.00', '10.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1541, 'pre', 46, 256, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1542, 'pre', 47, 256, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1543, 'pre', 48, 256, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1544, 'pre', 37, 258, '7.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '57.00', NULL, 'no', '2022-12-13 05:01:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1545, 'pre', 38, 258, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '51.00', NULL, 'no', '2022-12-13 05:01:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1546, 'pre', 39, 258, '10.00', '10.00', '9.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1547, 'pre', 40, 258, '7.00', '7.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1548, 'pre', 41, 258, '9.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1549, 'pre', 42, 258, '9.00', '7.00', '7.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1550, 'pre', 43, 258, '9.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1551, 'pre', 44, 258, '9.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1552, 'pre', 45, 258, '9.00', '9.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1553, 'pre', 46, 258, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1554, 'pre', 47, 258, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '41.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1555, 'pre', 48, 258, '10.00', '10.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1556, 'pre', 37, 259, '0.00', '10.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 06:09:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1557, 'pre', 38, 259, '8.00', '10.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 06:09:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1558, 'pre', 39, 259, '8.00', '4.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1559, 'pre', 40, 259, '7.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '33.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1560, 'pre', 41, 259, '7.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '23.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1561, 'pre', 42, 259, '7.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '23.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1562, 'pre', 43, 259, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '23.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1563, 'pre', 44, 259, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '23.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1564, 'ABS', 45, 259, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1565, 'pre', 46, 259, '10.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1566, 'pre', 47, 259, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1567, 'pre', 48, 259, '10.00', '8.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1568, 'pre', 37, 260, '10.00', '10.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 06:09:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1569, 'pre', 38, 260, '10.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 06:09:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1570, 'pre', 39, 260, '10.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1571, 'pre', 40, 260, '10.00', '7.00', '8.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1572, 'pre', 41, 260, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1573, 'pre', 42, 260, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1574, 'pre', 43, 260, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1575, 'pre', 44, 260, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1576, 'pre', 45, 260, '8.00', '8.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1577, 'pre', 46, 260, '10.00', '10.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1578, 'pre', 47, 260, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1579, 'pre', 48, 260, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1580, 'pre', 37, 261, '10.00', '8.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 05:01:56', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1581, 'pre', 38, 261, '10.00', '10.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 06:09:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1582, 'pre', 39, 261, '10.00', '8.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1583, 'pre', 40, 261, '10.00', '7.00', '8.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1584, 'pre', 41, 261, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1585, 'pre', 42, 261, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 06:37:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1586, 'pre', 43, 261, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1587, 'pre', 44, 261, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1588, 'pre', 45, 261, '8.00', '8.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1589, 'pre', 46, 261, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1590, 'pre', 47, 261, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1591, 'pre', 48, 261, '10.00', '8.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 07:07:33', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1592, 'pre', 49, 262, '10.00', '6.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1593, 'pre', 50, 262, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '54.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1594, 'pre', 51, 262, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1595, 'pre', 52, 262, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1596, 'pre', 53, 262, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1597, 'pre', 54, 262, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1598, 'pre', 55, 262, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1599, 'pre', 56, 262, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1600, 'pre', 57, 262, '9.00', '4.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:33:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1601, 'pre', 58, 262, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-13 08:33:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1602, 'pre', 59, 262, '9.00', '10.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1603, 'pre', 60, 262, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1604, 'pre', 49, 263, '10.00', '10.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1605, 'pre', 50, 263, '10.00', '10.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1606, 'pre', 51, 263, '9.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1607, 'pre', 52, 263, '9.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1608, 'pre', 53, 263, '6.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1609, 'pre', 54, 263, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1610, 'pre', 55, 263, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1611, 'pre', 56, 263, '6.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1612, 'pre', 57, 263, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-13 08:33:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1613, 'pre', 58, 263, '10.00', '10.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-13 08:33:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1614, 'pre', 59, 263, '10.00', '10.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1615, 'pre', 60, 263, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1616, 'pre', 49, 265, '5.00', '3.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1617, 'pre', 50, 265, '10.00', '5.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1618, 'pre', 51, 265, '8.00', '5.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '11.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1619, 'pre', 52, 265, '8.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '11.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1620, 'pre', 53, 265, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1621, 'pre', 54, 265, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1622, 'pre', 55, 265, '4.00', '3.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-13 08:33:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1623, 'pre', 56, 265, '8.00', '5.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:33:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1624, 'pre', 57, 265, '4.00', '3.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-13 08:33:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1625, 'pre', 58, 265, '10.00', '4.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 08:33:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1626, 'pre', 59, 265, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1627, 'pre', 60, 265, '10.00', '5.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '14.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1628, 'pre', 49, 264, '10.00', '5.00', '3.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1629, 'pre', 50, 264, '10.00', '10.00', '10.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '51.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1630, 'pre', 51, 264, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1631, 'pre', 52, 264, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1632, 'pre', 53, 264, '6.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1633, 'pre', 54, 264, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '24.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1634, 'pre', 55, 264, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '24.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1635, 'pre', 56, 264, '6.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1636, 'pre', 57, 264, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 08:33:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1637, 'pre', 58, 264, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 08:33:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1638, 'pre', 59, 264, '10.00', '10.00', '9.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1639, 'pre', 60, 264, '10.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1640, 'ABS', 49, 266, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1641, 'ABS', 50, 266, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1642, 'ABS', 51, 266, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1643, 'ABS', 52, 266, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1644, 'ABS', 53, 266, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1645, 'ABS', 54, 266, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1646, 'ABS', 55, 266, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1647, 'ABS', 56, 266, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1648, 'ABS', 57, 266, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1649, 'ABS', 58, 266, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1650, 'ABS', 59, 266, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1651, 'ABS', 60, 266, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1652, 'pre', 49, 267, '10.00', '10.00', '8.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1653, 'pre', 50, 267, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1654, 'pre', 51, 267, '8.00', '8.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1655, 'pre', 52, 267, '8.00', '8.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1656, 'pre', 53, 267, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '28.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1657, 'pre', 54, 267, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '28.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1658, 'pre', 55, 267, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '28.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1659, 'pre', 56, 267, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '28.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1660, 'pre', 57, 267, '8.00', '8.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 08:33:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1661, 'pre', 58, 267, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '57.00', NULL, 'no', '2022-12-13 08:33:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1662, 'pre', 59, 267, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1663, 'pre', 60, 267, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1664, 'pre', 49, 268, '8.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1665, 'pre', 50, 268, '10.00', '4.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1666, 'pre', 51, 268, '10.00', '10.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1667, 'pre', 52, 268, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1668, 'pre', 53, 268, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1669, 'pre', 54, 268, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1670, 'pre', 55, 268, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1671, 'pre', 56, 268, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1672, 'pre', 57, 268, '8.00', '8.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:33:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1673, 'pre', 58, 268, '10.00', '10.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-13 08:33:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1674, 'pre', 59, 268, '10.00', '8.00', '7.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1675, 'pre', 60, 268, '10.00', '8.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1676, 'pre', 49, 269, '10.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1677, 'pre', 50, 269, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1678, 'pre', 51, 269, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1679, 'pre', 52, 269, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1680, 'pre', 53, 269, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1681, 'pre', 54, 269, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1682, 'pre', 55, 269, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1683, 'pre', 56, 269, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1684, 'ABS', 57, 269, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:33:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1685, 'pre', 58, 269, '10.00', '10.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 08:33:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1686, 'pre', 59, 269, '10.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1687, 'ABS', 60, 269, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1688, 'pre', 49, 270, '5.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1689, 'pre', 50, 270, '10.00', '10.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '67.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1690, 'pre', 51, 270, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1691, 'pre', 52, 270, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1692, 'pre', 53, 270, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1693, 'pre', 54, 270, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1694, 'pre', 55, 270, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1695, 'pre', 56, 270, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 08:08:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1696, 'pre', 57, 270, '6.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 08:33:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1697, 'pre', 58, 270, '10.00', '10.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 08:33:06', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1698, 'pre', 59, 270, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '58.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1699, 'pre', 60, 270, '10.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '17.00', NULL, 'no', '2022-12-13 08:43:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1700, 'pre', 73, 272, '10.00', '8.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1701, 'pre', 74, 272, '4.00', '4.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1702, 'pre', 75, 272, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 11:26:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1703, 'pre', 76, 272, '10.00', '7.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 11:14:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1704, 'pre', 77, 272, '6.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1705, 'pre', 78, 272, '6.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1706, 'pre', 79, 272, '6.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1707, 'pre', 80, 272, '6.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1708, 'pre', 81, 272, '8.00', '5.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-13 12:04:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1709, 'pre', 82, 272, '10.00', '10.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 11:32:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1710, 'pre', 83, 272, '10.00', '8.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1711, 'pre', 84, 272, '8.00', '5.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1712, 'pre', 73, 273, '10.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1713, 'pre', 74, 273, '8.00', '9.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1714, 'pre', 75, 273, '10.00', '7.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:26:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1715, 'pre', 76, 273, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 11:14:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1716, 'pre', 77, 273, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1717, 'pre', 78, 273, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1718, 'pre', 79, 273, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1719, 'pre', 80, 273, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1720, 'pre', 81, 273, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:04:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1721, 'pre', 82, 273, '10.00', '10.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 11:32:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1722, 'pre', 83, 273, '10.00', '7.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1723, 'pre', 84, 273, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1724, 'pre', 73, 274, '10.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1725, 'pre', 74, 274, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1726, 'pre', 75, 274, '10.00', '8.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-13 11:26:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1727, 'pre', 76, 274, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-13 11:14:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1728, 'pre', 77, 274, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1729, 'pre', 78, 274, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1730, 'pre', 79, 274, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1731, 'pre', 80, 274, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1732, 'pre', 81, 274, '8.00', '7.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-13 12:04:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1733, 'pre', 82, 274, '10.00', '5.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 11:32:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1734, 'pre', 83, 274, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1735, 'pre', 84, 274, '8.00', '7.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1736, 'pre', 73, 276, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '38.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1737, 'pre', 74, 276, '5.00', '5.00', '7.00', '36.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1738, 'pre', 75, 276, '10.00', '10.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 11:26:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1739, 'pre', 76, 276, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 11:14:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1740, 'pre', 77, 276, '10.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1741, 'pre', 78, 276, '10.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1742, 'pre', 79, 276, '10.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1743, 'pre', 80, 276, '10.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1744, 'pre', 81, 276, '9.00', '8.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 12:04:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1745, 'pre', 82, 276, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:32:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1746, 'pre', 83, 276, '10.00', '10.00', '9.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1747, 'pre', 84, 276, '9.00', '8.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1748, 'pre', 73, 277, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1749, 'pre', 74, 277, '10.00', '8.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '57.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1750, 'pre', 75, 277, '10.00', '10.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-13 11:26:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1751, 'pre', 76, 277, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 11:14:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1752, 'pre', 77, 277, '8.00', '8.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1753, 'pre', 78, 277, '8.00', '8.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1754, 'pre', 79, 277, '8.00', '8.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1755, 'pre', 80, 277, '8.00', '8.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1756, 'pre', 81, 277, '8.00', '5.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-13 12:04:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1757, 'pre', 82, 277, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 11:32:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1758, 'pre', 83, 277, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1759, 'pre', 84, 277, '8.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1760, 'pre', 73, 278, '10.00', '10.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1761, 'pre', 74, 278, '6.00', '7.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1762, 'pre', 75, 278, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-13 11:26:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1763, 'pre', 76, 278, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '28.00', NULL, 'no', '2022-12-13 11:14:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1764, 'pre', 77, 278, '10.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1765, 'pre', 78, 278, '10.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1766, 'pre', 79, 278, '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1767, 'pre', 80, 278, '10.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1768, 'pre', 81, 278, '9.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:04:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1769, 'pre', 82, 278, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '53.00', NULL, 'no', '2022-12-13 11:32:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1770, 'pre', 83, 278, '10.00', '10.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1771, 'pre', 84, 278, '9.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1772, 'pre', 73, 280, '10.00', '10.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '38.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1773, 'pre', 74, 280, '6.00', '6.00', '5.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1774, 'pre', 75, 280, '10.00', '10.00', '8.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 11:26:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1775, 'pre', 76, 280, '10.00', '7.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:14:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1776, 'pre', 77, 280, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1777, 'pre', 78, 280, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1778, 'pre', 79, 280, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1779, 'pre', 80, 280, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1780, 'pre', 81, 280, '8.00', '5.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-13 12:04:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1781, 'pre', 82, 280, '10.00', '10.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 11:32:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1782, 'pre', 83, 280, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1783, 'pre', 84, 280, '8.00', '4.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1784, 'pre', 73, 281, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1785, 'pre', 74, 281, '7.00', '7.00', '5.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1786, 'pre', 75, 281, '10.00', '10.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 11:26:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1787, 'pre', 76, 281, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-13 11:14:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1788, 'pre', 77, 281, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1789, 'pre', 78, 281, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1790, 'pre', 79, 281, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1791, 'pre', 80, 281, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1792, 'pre', 81, 281, '8.00', '6.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 12:04:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1793, 'pre', 82, 281, '10.00', '10.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:32:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1794, 'pre', 83, 281, '10.00', '5.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1795, 'pre', 84, 281, '8.00', '6.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1796, 'pre', 73, 282, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1797, 'pre', 74, 282, '6.00', '6.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1798, 'pre', 75, 282, '10.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-13 11:26:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1799, 'ABS', 76, 282, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-13 11:14:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1800, 'pre', 77, 282, '8.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1801, 'pre', 78, 282, '8.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1802, 'pre', 79, 282, '8.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1803, 'pre', 80, 282, '8.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:30', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1804, 'pre', 81, 282, '8.00', '5.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-13 12:04:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1805, 'pre', 82, 282, '10.00', '5.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '23.00', NULL, 'no', '2022-12-13 11:32:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1806, 'pre', 83, 282, '10.00', '8.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1807, 'pre', 84, 282, '8.00', '5.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1808, 'pre', 73, 283, '10.00', '10.00', '9.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1809, 'pre', 74, 283, '2.00', '2.00', '2.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1810, 'pre', 75, 283, '10.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-13 11:26:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1811, 'pre', 76, 283, '10.00', '7.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-13 11:14:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1812, 'pre', 77, 283, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1813, 'pre', 78, 283, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1814, 'pre', 79, 283, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1815, 'pre', 80, 283, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:36:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1816, 'pre', 81, 283, '8.00', '8.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:04:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1817, 'pre', 82, 283, '10.00', '10.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-13 11:32:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1818, 'pre', 83, 283, '10.00', '7.00', '6.00', '0.50', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1819, 'pre', 84, 283, '8.00', '8.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1820, 'pre', 73, 285, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1821, 'pre', 74, 285, '8.00', '9.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1822, 'pre', 75, 285, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 11:26:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1823, 'pre', 76, 285, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-19 00:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1824, 'pre', 77, 285, '10.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:36:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1825, 'pre', 78, 285, '10.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:36:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1826, 'pre', 79, 285, '10.00', '0.00', '0.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:36:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1827, 'pre', 80, 285, '10.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:36:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1828, 'pre', 81, 285, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 12:04:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1829, 'pre', 82, 285, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 11:32:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1830, 'pre', 83, 285, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1831, 'pre', 84, 285, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1832, 'pre', 73, 286, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1833, 'pre', 74, 286, '8.00', '8.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-13 11:06:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1834, 'pre', 75, 286, '10.00', '10.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:26:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1835, 'pre', 76, 286, '10.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 11:14:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1836, 'pre', 77, 286, '8.00', '8.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 12:36:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1837, 'pre', 78, 286, '8.00', '8.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 12:36:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1838, 'pre', 79, 286, '8.00', '8.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 12:36:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1839, 'pre', 80, 286, '8.00', '8.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 12:36:31', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1840, 'pre', 81, 286, '8.00', '8.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:04:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1841, 'pre', 82, 286, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 11:32:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1842, 'pre', 83, 286, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1843, 'pre', 84, 286, '8.00', '4.00', '4.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 11:53:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1844, 'pre', 85, 287, '10.00', '9.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-13 12:51:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1845, 'pre', 86, 287, '8.00', '6.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 12:51:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1846, 'pre', 87, 287, '10.00', '5.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 22:24:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1847, 'pre', 88, 287, '10.00', '10.00', '8.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 22:24:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1848, 'pre', 89, 287, '7.00', '7.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '29.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1849, 'pre', 90, 287, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '32.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1850, 'pre', 91, 287, '7.00', '7.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '29.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1851, 'pre', 92, 287, '7.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '29.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1852, 'pre', 93, 287, '6.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1853, 'pre', 94, 287, '10.00', '10.00', '6.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1854, 'pre', 95, 287, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '32.00', NULL, 'no', '2022-12-13 23:02:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1855, 'pre', 96, 287, '8.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1856, 'pre', 85, 290, '10.00', '8.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-13 12:51:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1857, 'pre', 86, 290, '10.00', '8.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 12:51:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1858, 'pre', 87, 290, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 22:24:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1859, 'pre', 88, 290, '7.00', '7.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-13 22:24:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1860, 'pre', 89, 290, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '29.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1861, 'pre', 90, 290, '10.00', '10.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1862, 'pre', 91, 290, '7.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '29.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1863, 'pre', 92, 290, '7.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '29.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1864, 'pre', 93, 290, '8.00', '8.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1865, 'pre', 94, 290, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1866, 'pre', 95, 290, '10.00', '10.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 23:02:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1867, 'pre', 96, 290, '10.00', '8.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1868, 'pre', 85, 291, '10.00', '8.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-13 12:51:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1869, 'pre', 86, 291, '10.00', '9.00', '9.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 12:51:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1870, 'pre', 87, 291, '10.00', '10.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-13 22:24:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1871, 'pre', 88, 291, '10.00', '9.00', '9.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 22:24:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1872, 'pre', 89, 291, '10.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1873, 'pre', 90, 291, '10.00', '10.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1874, 'pre', 91, 291, '10.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1875, 'pre', 92, 291, '10.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1876, 'pre', 93, 291, '8.00', '8.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1877, 'pre', 94, 291, '10.00', '9.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1878, 'pre', 95, 291, '10.00', '10.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 23:02:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1879, 'pre', 96, 291, '9.00', '8.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1880, 'pre', 85, 292, '10.00', '8.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:51:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1881, 'pre', 86, 292, '9.00', '7.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 12:51:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1882, 'pre', 87, 292, '10.00', '5.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-13 22:24:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1883, 'pre', 88, 292, '10.00', '4.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 22:24:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1884, 'pre', 89, 292, '10.00', '8.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1885, 'pre', 90, 292, '10.00', '5.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1886, 'pre', 91, 292, '10.00', '8.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1887, 'pre', 92, 292, '10.00', '8.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1888, 'pre', 93, 292, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1889, 'pre', 94, 292, '10.00', '6.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1890, 'pre', 95, 292, '10.00', '5.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 23:02:37', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1891, 'pre', 96, 292, '8.00', '6.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1892, 'pre', 85, 293, '10.00', '10.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-13 12:51:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1893, 'pre', 86, 293, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 12:51:36', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1894, 'pre', 87, 293, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 22:24:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1895, 'pre', 88, 293, '10.00', '10.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-13 22:24:46', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1896, 'pre', 89, 293, '10.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1897, 'pre', 90, 293, '10.00', '7.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1898, 'pre', 91, 293, '10.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1899, 'pre', 92, 293, '10.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 22:41:52', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1900, 'pre', 93, 293, '6.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1901, 'pre', 94, 293, '10.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1902, 'pre', 95, 293, '10.00', '7.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-13 23:03:18', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1903, 'pre', 96, 293, '9.00', '8.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 22:54:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1904, 'pre', 151, 287, '7.00', '7.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '29.00', NULL, 'no', '2022-12-13 23:16:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1905, 'pre', 153, 287, '8.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-13 23:16:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1906, 'pre', 151, 290, '7.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '29.00', NULL, 'no', '2022-12-13 23:16:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1907, 'pre', 153, 290, '10.00', '8.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-13 23:16:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1908, 'pre', 151, 291, '10.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 23:16:17', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1909, 'pre', 153, 291, '9.00', '8.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 23:16:17', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1910, 'pre', 151, 292, '10.00', '8.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-13 23:16:17', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1911, 'pre', 153, 292, '8.00', '6.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-13 23:16:17', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1912, 'pre', 151, 293, '10.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-13 23:16:17', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1913, 'pre', 153, 293, '9.00', '8.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-13 23:16:17', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1914, 'pre', 110, 101, '10.00', '8.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 00:11:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1915, 'pre', 111, 101, '10.00', '7.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '43.00', NULL, 'no', '2022-12-14 00:11:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1916, 'pre', 112, 101, '5.00', '5.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1917, 'pre', 113, 101, '10.00', '8.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1918, 'pre', 114, 101, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1919, 'pre', 115, 101, '3.00', '3.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-14 22:09:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1920, 'pre', 116, 101, '8.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1921, 'pre', 117, 101, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1922, 'pre', 118, 101, '5.00', '6.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1923, 'pre', 119, 101, '7.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-14 13:48:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1924, 'pre', 120, 101, '6.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 14:46:00', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1925, 'pre', 121, 101, '10.00', '8.00', '8.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1926, 'pre', 122, 101, '10.00', '9.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1927, 'pre', 110, 102, '10.00', '7.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1928, 'pre', 111, 102, '10.00', '5.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-14 00:11:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1929, 'pre', 112, 102, '3.00', '3.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '23.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1930, 'pre', 113, 102, '10.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1931, 'pre', 114, 102, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1932, 'pre', 115, 102, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '14.00', NULL, 'no', '2022-12-14 22:09:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1933, 'pre', 116, 102, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1934, 'pre', 117, 102, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1935, 'pre', 118, 102, '5.00', '4.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1936, 'pre', 119, 102, '7.00', '6.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 13:48:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1937, 'pre', 120, 102, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1938, 'pre', 121, 102, '10.00', '8.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1939, 'pre', 122, 102, '9.00', '5.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1940, 'pre', 110, 103, '10.00', '10.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1941, 'pre', 111, 103, '10.00', '8.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1942, 'pre', 112, 103, '10.00', '10.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1943, 'pre', 113, 103, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1944, 'pre', 114, 103, '10.00', '10.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1945, 'pre', 115, 103, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 22:09:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1946, 'pre', 116, 103, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1947, 'pre', 117, 103, '10.00', '10.00', '8.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1948, 'pre', 118, 103, '10.00', '9.00', '9.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1949, 'pre', 119, 103, '10.00', '9.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 13:48:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1950, 'pre', 120, 103, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1951, 'pre', 121, 103, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1952, 'pre', 122, 103, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '51.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1953, 'pre', 110, 104, '10.00', '8.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1954, 'pre', 111, 104, '9.00', '6.00', '6.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '34.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1955, 'pre', 112, 104, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '6.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1956, 'pre', 113, 104, '10.00', '9.00', '9.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1957, 'pre', 114, 104, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1958, 'pre', 115, 104, '3.00', '3.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 22:09:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1959, 'pre', 116, 104, '6.00', '5.00', '5.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1960, 'pre', 117, 104, '10.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1961, 'pre', 118, 104, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1962, 'pre', 119, 104, '8.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 13:48:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1963, 'pre', 120, 104, '6.00', '5.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1964, 'pre', 121, 104, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1965, 'pre', 122, 104, '10.00', '10.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1966, 'pre', 110, 105, '10.00', '10.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1967, 'pre', 111, 105, '10.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '34.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1968, 'pre', 112, 105, '5.00', '5.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1969, 'pre', 113, 105, '10.00', '10.00', '8.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1970, 'pre', 114, 105, '5.00', '5.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1971, 'pre', 115, 105, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-14 22:09:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1972, 'pre', 116, 105, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '43.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1973, 'pre', 117, 105, '10.00', '7.00', '3.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1974, 'pre', 118, 105, '9.00', '6.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1975, 'pre', 119, 105, '10.00', '10.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 13:48:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1976, 'pre', 120, 105, '5.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1977, 'pre', 121, 105, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1978, 'pre', 122, 105, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1979, 'pre', 110, 106, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1980, 'pre', 111, 106, '10.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1981, 'pre', 112, 106, '8.00', '8.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1982, 'pre', 113, 106, '10.00', '10.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1983, 'pre', 114, 106, '10.00', '10.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1984, 'pre', 115, 106, '4.00', '4.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 22:09:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1985, 'pre', 116, 106, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '49.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1986, 'pre', 117, 106, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1987, 'pre', 118, 106, '9.00', '9.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1988, 'pre', 119, 106, '9.00', '9.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 13:48:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1989, 'pre', 120, 106, '9.00', '9.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1990, 'pre', 121, 106, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1991, 'pre', 122, 106, '10.00', '10.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1992, 'pre', 110, 107, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1993, 'pre', 111, 107, '8.00', '8.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1994, 'pre', 112, 107, '4.00', '3.00', '3.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1995, 'pre', 113, 107, '10.00', '10.00', '9.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1996, 'pre', 114, 107, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1997, 'pre', 115, 107, '3.00', '3.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '13.00', NULL, 'no', '2022-12-14 22:09:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1998, 'pre', 116, 107, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '49.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (1999, 'pre', 117, 107, '10.00', '8.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2000, 'pre', 118, 107, '6.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2001, 'pre', 119, 107, '6.00', '6.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 13:48:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2002, 'pre', 120, 107, '6.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2003, 'pre', 121, 107, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2004, 'pre', 122, 107, '10.00', '8.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2005, 'pre', 110, 307, '10.00', '7.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2006, 'pre', 111, 307, '10.00', '8.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '44.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2007, 'pre', 112, 307, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2008, 'pre', 113, 307, '10.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2009, 'pre', 114, 307, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2010, 'pre', 115, 307, '5.00', '5.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '13.00', NULL, 'no', '2022-12-14 22:09:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2011, 'pre', 116, 307, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2012, 'pre', 117, 307, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2013, 'pre', 118, 307, '8.00', '8.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2014, 'pre', 119, 307, '9.00', '9.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 13:48:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2015, 'pre', 120, 307, '9.00', '9.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2016, 'ABS', 121, 307, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2017, 'pre', 122, 307, '10.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2018, 'pre', 110, 108, '10.00', '10.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2019, 'pre', 111, 108, '10.00', '7.00', '7.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2020, 'pre', 112, 108, '2.00', '3.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:57:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2021, 'pre', 113, 108, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2022, 'pre', 114, 108, '10.00', '8.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2023, 'pre', 115, 108, '5.00', '5.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 22:09:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2024, 'pre', 116, 108, '10.00', '7.00', '1.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2025, 'pre', 117, 108, '10.00', '3.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2026, 'pre', 118, 108, '9.00', '9.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2027, 'pre', 119, 108, '6.00', '6.00', '4.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 13:48:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2028, 'pre', 120, 108, '5.00', '5.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2029, 'pre', 121, 108, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2030, 'pre', 122, 108, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2031, 'pre', 110, 109, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2032, 'pre', 111, 109, '10.00', '9.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2033, 'pre', 112, 109, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-14 15:57:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2034, 'pre', 113, 109, '10.00', '10.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2035, 'pre', 114, 109, '10.00', '10.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2036, 'pre', 115, 109, '8.00', '8.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '48.00', NULL, 'no', '2022-12-14 22:09:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2037, 'pre', 116, 109, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2038, 'pre', 117, 109, '10.00', '10.00', '4.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2039, 'pre', 118, 109, '8.00', '8.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2040, 'pre', 119, 109, '10.00', '10.00', '8.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 13:48:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2041, 'pre', 120, 109, '10.00', '10.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2042, 'pre', 121, 109, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2043, 'pre', 122, 109, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2044, 'pre', 110, 110, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2045, 'pre', 111, 110, '10.00', '9.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2046, 'pre', 112, 110, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-14 15:57:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2047, 'pre', 113, 110, '10.00', '10.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2048, 'pre', 114, 110, '10.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2049, 'pre', 115, 110, '3.00', '3.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 22:09:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2050, 'pre', 116, 110, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '54.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2051, 'pre', 117, 110, '10.00', '5.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2052, 'pre', 118, 110, '9.00', '9.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2053, 'pre', 119, 110, '9.00', '9.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2054, 'pre', 120, 110, '9.00', '7.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2055, 'pre', 121, 110, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2056, 'pre', 122, 110, '10.00', '7.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2057, 'pre', 110, 111, '10.00', '10.00', '10.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2058, 'pre', 111, 111, '10.00', '9.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '43.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2059, 'pre', 112, 111, '6.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '38.00', NULL, 'no', '2022-12-14 15:57:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2060, 'pre', 113, 111, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2061, 'pre', 114, 111, '10.00', '10.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2062, 'pre', 115, 111, '5.00', '5.00', '5.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-14 22:09:11', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2063, 'pre', 116, 111, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2064, 'pre', 117, 111, '7.00', '5.00', '3.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2065, 'pre', 118, 111, '6.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2066, 'pre', 119, 111, '10.00', '10.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2067, 'pre', 120, 111, '6.00', '6.00', '6.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2068, 'pre', 121, 111, '10.00', '10.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2069, 'pre', 122, 111, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '32.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2070, 'pre', 110, 112, '10.00', '10.00', '10.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2071, 'pre', 111, 112, '10.00', '9.00', '7.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2072, 'pre', 112, 112, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-14 15:57:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2073, 'pre', 113, 112, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2074, 'pre', 114, 112, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '51.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2075, 'pre', 115, 112, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '54.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2076, 'pre', 116, 112, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2077, 'pre', 117, 112, '10.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2078, 'pre', 118, 112, '9.00', '9.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '65.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2079, 'pre', 119, 112, '9.00', '9.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2080, 'pre', 120, 112, '8.00', '8.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2081, 'pre', 121, 112, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2082, 'pre', 122, 112, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2083, 'ABS', 110, 113, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2084, 'ABS', 111, 113, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2085, 'ABS', 112, 113, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2086, 'ABS', 113, 113, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2087, 'ABS', 114, 113, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2088, 'ABS', 115, 113, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2089, 'ABS', 116, 113, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2090, 'ABS', 117, 113, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2091, 'ABS', 118, 113, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2092, 'ABS', 119, 113, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2093, 'ABS', 120, 113, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2094, 'ABS', 121, 113, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2095, 'ABS', 122, 113, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2096, 'pre', 110, 114, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2097, 'pre', 111, 114, '9.00', '9.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2098, 'pre', 112, 114, '10.00', '10.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-14 15:57:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2099, 'pre', 113, 114, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2100, 'pre', 114, 114, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2101, 'pre', 115, 114, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '2.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2102, 'pre', 116, 114, '10.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2103, 'pre', 117, 114, '10.00', '10.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2104, 'pre', 118, 114, '9.00', '9.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2105, 'pre', 119, 114, '9.00', '9.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2106, 'pre', 120, 114, '9.00', '9.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2107, 'pre', 121, 114, '10.00', '10.00', '10.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2108, 'pre', 122, 114, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '27.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2109, 'pre', 110, 115, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2110, 'pre', 111, 115, '10.00', '8.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 00:11:43', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2111, 'pre', 112, 115, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-18 16:34:47', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2112, 'pre', 113, 115, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2113, 'pre', 114, 115, '10.00', '10.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2114, 'pre', 115, 115, '5.00', '5.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2115, 'pre', 116, 115, '10.00', '10.00', '10.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '33.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2116, 'pre', 117, 115, '10.00', '7.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2117, 'pre', 118, 115, '8.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-14 12:37:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2118, 'pre', 119, 115, '10.00', '9.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2119, 'pre', 120, 115, '9.00', '9.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2120, 'pre', 121, 115, '10.00', '10.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2121, 'pre', 122, 115, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2122, 'pre', 110, 308, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2123, 'pre', 111, 308, '10.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2124, 'pre', 112, 308, '10.00', '10.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-14 15:57:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2125, 'pre', 113, 308, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2126, 'pre', 114, 308, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2127, 'pre', 115, 308, '5.00', '5.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2128, 'pre', 116, 308, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '43.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2129, 'pre', 117, 308, '10.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2130, 'pre', 118, 308, '8.00', '8.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2131, 'pre', 119, 308, '9.00', '9.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2132, 'pre', 120, 308, '10.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2133, 'pre', 121, 308, '10.00', '10.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2134, 'pre', 122, 308, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2135, 'pre', 110, 117, '10.00', '10.00', '7.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2136, 'pre', 111, 117, '9.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2137, 'pre', 112, 117, '3.00', '3.00', '4.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 15:57:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2138, 'pre', 113, 117, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2139, 'pre', 114, 117, '10.00', '8.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2140, 'pre', 115, 117, '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2141, 'pre', 116, 117, '10.00', '10.00', '10.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2142, 'pre', 117, 117, '8.00', '7.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2143, 'pre', 118, 117, '8.00', '8.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2144, 'pre', 119, 117, '8.00', '8.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2145, 'pre', 120, 117, '9.00', '9.00', '8.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2146, 'pre', 121, 117, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:01', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2147, 'pre', 122, 117, '10.00', '7.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2148, 'pre', 110, 118, '10.00', '10.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2149, 'pre', 111, 118, '9.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2150, 'pre', 112, 118, '8.00', '8.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-14 15:57:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2151, 'pre', 113, 118, '10.00', '10.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2152, 'pre', 114, 118, '10.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2153, 'pre', 115, 118, '8.00', '8.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2154, 'pre', 116, 118, '10.00', '8.00', '2.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2155, 'pre', 117, 118, '10.00', '4.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:45:48', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2156, 'pre', 118, 118, '8.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2157, 'pre', 119, 118, '6.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2158, 'pre', 120, 118, '8.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2159, 'pre', 121, 118, '10.00', '10.00', '8.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2160, 'pre', 122, 118, '7.00', '7.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2161, 'pre', 110, 309, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2162, 'pre', 111, 309, '9.00', '9.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2163, 'pre', 112, 309, '8.00', '8.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-14 15:57:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2164, 'pre', 113, 309, '10.00', '9.00', '9.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2165, 'pre', 114, 309, '10.00', '6.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2166, 'pre', 115, 309, '4.00', '4.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2167, 'pre', 116, 309, '10.00', '6.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2168, 'pre', 117, 309, '10.00', '8.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2169, 'pre', 118, 309, '10.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2170, 'pre', 119, 309, '10.00', '9.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2171, 'pre', 120, 309, '8.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2172, 'pre', 121, 309, '10.00', '10.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2173, 'pre', 122, 309, '10.00', '10.00', '8.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2174, 'pre', 110, 119, '10.00', '10.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2175, 'pre', 111, 119, '9.00', '8.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2176, 'pre', 112, 119, '4.00', '3.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:57:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2177, 'pre', 113, 119, '10.00', '10.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2178, 'pre', 114, 119, '10.00', '6.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2179, 'pre', 115, 119, '8.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2180, 'pre', 116, 119, '10.00', '10.00', '10.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2181, 'pre', 117, 119, '10.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2182, 'pre', 118, 119, '6.00', '6.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2183, 'pre', 119, 119, '10.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2184, 'pre', 120, 119, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2185, 'pre', 121, 119, '10.00', '10.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2186, 'pre', 122, 119, '7.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2187, 'pre', 110, 120, '10.00', '7.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2188, 'pre', 111, 120, '7.00', '5.00', '4.00', '20.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2189, 'pre', 112, 120, '4.00', '4.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '8.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2190, 'pre', 113, 120, '10.00', '9.00', '4.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2191, 'pre', 114, 120, '10.00', '8.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2192, 'pre', 115, 120, '6.00', '5.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '9.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2193, 'pre', 116, 120, '10.00', '10.00', '5.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '32.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2194, 'pre', 117, 120, '10.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '41.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2195, 'pre', 118, 120, '8.00', '5.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2196, 'pre', 119, 120, '6.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2197, 'pre', 120, 120, '8.00', '6.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2198, 'pre', 121, 120, '10.00', '10.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2199, 'pre', 122, 120, '10.00', '10.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2200, 'pre', 110, 121, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2201, 'pre', 111, 121, '10.00', '9.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2202, 'pre', 112, 121, '8.00', '8.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '43.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2203, 'pre', 113, 121, '10.00', '10.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2204, 'pre', 114, 121, '10.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2205, 'pre', 115, 121, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2206, 'pre', 116, 121, '10.00', '10.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2207, 'pre', 117, 121, '10.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2208, 'pre', 118, 121, '5.00', '7.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2209, 'pre', 119, 121, '8.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2210, 'pre', 120, 121, '8.00', '7.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2211, 'pre', 121, 121, '10.00', '10.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2212, 'pre', 122, 121, '10.00', '9.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2213, 'pre', 110, 122, '10.00', '7.00', '7.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2214, 'pre', 111, 122, '10.00', '10.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2215, 'pre', 112, 122, '4.00', '3.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '5.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2216, 'pre', 113, 122, '10.00', '8.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2217, 'pre', 114, 122, '10.00', '3.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2218, 'pre', 115, 122, '7.00', '3.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-14 22:29:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2219, 'pre', 116, 122, '10.00', '4.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2220, 'pre', 117, 122, '10.00', '9.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2221, 'pre', 118, 122, '5.00', '9.00', '9.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2222, 'pre', 119, 122, '7.00', '7.00', '6.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2223, 'pre', 120, 122, '7.00', '7.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2224, 'pre', 121, 122, '10.00', '10.00', '8.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2225, 'pre', 122, 122, '10.00', '6.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2226, 'pre', 110, 123, '10.00', '7.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2227, 'pre', 111, 123, '10.00', '8.00', '3.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2228, 'pre', 112, 123, '3.00', '3.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '4.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2229, 'pre', 113, 123, '10.00', '8.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2230, 'pre', 114, 123, '10.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-14 02:08:39', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2231, 'pre', 115, 123, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '3.00', NULL, 'no', '2022-12-14 22:29:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2232, 'pre', 116, 123, '10.00', '7.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2233, 'pre', 117, 123, '10.00', '8.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2234, 'pre', 118, 123, '4.00', '4.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2235, 'pre', 119, 123, '6.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2236, 'pre', 120, 123, '8.00', '3.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2237, 'pre', 121, 123, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2238, 'pre', 122, 123, '10.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '17.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2239, 'pre', 110, 125, '10.00', '7.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2240, 'pre', 111, 125, '9.00', '8.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2241, 'pre', 112, 125, '4.00', '3.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '14.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2242, 'pre', 113, 125, '10.00', '8.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2243, 'pre', 114, 125, '10.00', '6.00', '3.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2244, 'pre', 115, 125, '10.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-14 22:29:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2245, 'pre', 116, 125, '10.00', '7.00', '1.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2246, 'pre', 117, 125, '10.00', '5.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2247, 'pre', 118, 125, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2248, 'pre', 119, 125, '7.00', '7.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2249, 'pre', 120, 125, '6.00', '3.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2250, 'pre', 121, 125, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '31.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2251, 'pre', 122, 125, '7.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2252, 'pre', 110, 126, '10.00', '9.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2253, 'pre', 111, 126, '9.00', '8.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2254, 'pre', 112, 126, '6.00', '5.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '31.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2255, 'pre', 113, 126, '10.00', '10.00', '9.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2256, 'pre', 114, 126, '10.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2257, 'pre', 115, 126, '5.00', '4.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-14 22:29:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2258, 'pre', 116, 126, '10.00', '8.00', '5.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2259, 'pre', 117, 126, '10.00', '6.00', '5.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2260, 'pre', 118, 126, '6.00', '6.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2261, 'pre', 119, 126, '7.00', '7.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2262, 'pre', 120, 126, '7.00', '6.00', '6.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2263, 'pre', 121, 126, '10.00', '10.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2264, 'pre', 122, 126, '10.00', '7.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2265, 'pre', 110, 127, '10.00', '10.00', '7.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2266, 'pre', 111, 127, '10.00', '8.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2267, 'ABS', 112, 127, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2268, 'pre', 113, 127, '10.00', '7.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2269, 'pre', 114, 127, '10.00', '9.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2270, 'pre', 115, 127, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '34.00', NULL, 'no', '2022-12-14 22:29:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2271, 'pre', 116, 127, '10.00', '6.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2272, 'pre', 117, 127, '10.00', '9.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2273, 'pre', 118, 127, '9.00', '9.00', '6.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2274, 'pre', 119, 127, '7.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2275, 'pre', 120, 127, '8.00', '8.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2276, 'pre', 121, 127, '10.00', '10.00', '10.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2277, 'pre', 122, 127, '9.00', '8.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2278, 'ABS', 110, 128, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2279, 'ABS', 111, 128, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2280, 'ABS', 112, 128, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2281, 'ABS', 113, 128, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2282, 'ABS', 114, 128, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2283, 'ABS', 115, 128, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2284, 'ABS', 116, 128, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2285, 'ABS', 117, 128, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2286, 'ABS', 118, 128, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2287, 'ABS', 119, 128, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2288, 'pre', 120, 128, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2289, 'ABS', 121, 128, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2290, 'ABS', 122, 128, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2291, 'ABS', 110, 149, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2292, 'ABS', 111, 149, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2293, 'ABS', 112, 149, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2294, 'ABS', 113, 149, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2295, 'ABS', 114, 149, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2296, 'ABS', 115, 149, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2297, 'ABS', 116, 149, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2298, 'ABS', 117, 149, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2299, 'ABS', 118, 149, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2300, 'ABS', 119, 149, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2301, 'ABS', 120, 149, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2302, 'ABS', 121, 149, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:02', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2303, 'ABS', 122, 149, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2304, 'pre', 110, 129, '10.00', '10.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2305, 'pre', 111, 129, '8.00', '5.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2306, 'pre', 112, 129, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '3.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2307, 'pre', 113, 129, '10.00', '7.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2308, 'pre', 114, 129, '5.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '12.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2309, 'pre', 115, 129, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '3.00', NULL, 'no', '2022-12-14 22:29:41', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2310, 'pre', 116, 129, '9.00', '5.00', '2.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2311, 'pre', 117, 129, '5.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2312, 'pre', 118, 129, '5.00', '4.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2313, 'pre', 119, 129, '6.00', '5.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2314, 'pre', 120, 129, '8.00', '5.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2315, 'pre', 121, 129, '10.00', '10.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2316, 'pre', 122, 129, '10.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-14 15:21:25', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2317, 'pre', 110, 131, '10.00', '5.00', '7.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2318, 'pre', 111, 131, '10.00', '8.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2319, 'pre', 112, 131, '5.00', '5.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2320, 'pre', 113, 131, '10.00', '7.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2321, 'pre', 114, 131, '10.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '28.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2322, 'pre', 115, 131, '4.00', '4.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '24.00', NULL, 'no', '2022-12-14 22:29:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2323, 'pre', 116, 131, '10.00', '10.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2324, 'pre', 117, 131, '5.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2325, 'pre', 118, 131, '5.00', '5.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2326, 'pre', 119, 131, '9.00', '9.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2327, 'pre', 120, 131, '8.00', '8.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2328, 'pre', 121, 131, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2329, 'pre', 122, 131, '10.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:21:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2330, 'pre', 110, 132, '10.00', '7.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2331, 'pre', 111, 132, '9.00', '7.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2332, 'pre', 112, 132, '4.00', '3.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '14.00', NULL, 'no', '2022-12-14 22:09:12', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2333, 'pre', 113, 132, '10.00', '7.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2334, 'pre', 114, 132, '10.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2335, 'pre', 115, 132, '3.00', '2.00', '2.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '3.00', NULL, 'no', '2022-12-14 22:29:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2336, 'pre', 116, 132, '5.00', '4.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2337, 'pre', 117, 132, '5.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2338, 'pre', 118, 132, '4.00', '4.00', '3.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2339, 'pre', 119, 132, '7.00', '4.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2340, 'pre', 120, 132, '6.00', '4.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2341, 'pre', 121, 132, '10.00', '5.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2342, 'pre', 122, 132, '10.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 15:21:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2343, 'pre', 110, 134, '10.00', '7.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2344, 'pre', 111, 134, '7.00', '7.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '38.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2345, 'pre', 112, 134, '5.00', '50.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '14.00', NULL, 'no', '2022-12-18 16:37:29', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2346, 'pre', 113, 134, '10.00', '7.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2347, 'pre', 114, 134, '5.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2348, 'pre', 115, 134, '3.00', '3.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '12.00', NULL, 'no', '2022-12-14 22:29:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2349, 'pre', 116, 134, '10.00', '8.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2350, 'pre', 117, 134, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2351, 'pre', 118, 134, '6.00', '6.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2352, 'pre', 119, 134, '8.00', '4.00', '4.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2353, 'pre', 120, 134, '8.00', '7.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2354, 'pre', 121, 134, '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2355, 'pre', 122, 134, '10.00', '9.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:21:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2356, 'pre', 110, 135, '10.00', '10.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2357, 'pre', 111, 135, '10.00', '8.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2358, 'pre', 112, 135, '8.00', '8.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 22:09:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2359, 'pre', 113, 135, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2360, 'pre', 114, 135, '10.00', '7.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2361, 'pre', 115, 135, '5.00', '5.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '53.00', NULL, 'no', '2022-12-14 22:29:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2362, 'pre', 116, 135, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2363, 'pre', 117, 135, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2364, 'pre', 118, 135, '9.00', '9.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2365, 'pre', 119, 135, '10.00', '10.00', '6.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2366, 'pre', 120, 135, '10.00', '9.00', '9.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2367, 'pre', 121, 135, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2368, 'pre', 122, 135, '10.00', '10.00', '10.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '42.00', NULL, 'no', '2022-12-14 15:21:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2369, 'pre', 110, 136, '10.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2370, 'pre', 111, 136, '9.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2371, 'pre', 112, 136, '1.00', '1.00', '1.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '3.00', NULL, 'no', '2022-12-14 22:09:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2372, 'pre', 113, 136, '10.00', '8.00', '7.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2373, 'pre', 114, 136, '10.00', '3.00', '1.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2374, 'pre', 115, 136, '2.00', '2.00', '1.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '5.00', NULL, 'no', '2022-12-14 22:29:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2375, 'pre', 116, 136, '10.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2376, 'pre', 117, 136, '10.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2377, 'pre', 118, 136, '4.00', '4.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2378, 'pre', 119, 136, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2379, 'pre', 120, 136, '6.00', '6.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '13.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2380, 'pre', 121, 136, '10.00', '5.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2381, 'pre', 122, 136, '10.00', '9.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:21:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2382, 'pre', 110, 139, '10.00', '8.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2383, 'pre', 111, 139, '9.00', '8.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2384, 'pre', 112, 139, '55.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '21.00', NULL, 'no', '2022-12-14 22:09:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2385, 'pre', 113, 139, '10.00', '8.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2386, 'pre', 114, 139, '10.00', '6.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2387, 'pre', 115, 139, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '41.00', NULL, 'no', '2022-12-14 22:29:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2388, 'pre', 116, 139, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 11:59:19', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2389, 'pre', 117, 139, '10.00', '9.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2390, 'pre', 118, 139, '10.00', '8.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2391, 'pre', 119, 139, '8.00', '6.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 13:48:27', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2392, 'pre', 120, 139, '7.00', '7.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2393, 'pre', 121, 139, '10.00', '10.00', '10.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:03', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2394, 'pre', 122, 139, '10.00', '8.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:21:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2395, 'pre', 110, 140, '10.00', '10.00', '8.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2396, 'pre', 111, 140, '10.00', '8.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2397, 'pre', 112, 140, '10.00', '5.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 22:09:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2398, 'pre', 113, 140, '10.00', '10.00', '10.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2399, 'pre', 114, 140, '10.00', '5.00', '6.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2400, 'pre', 115, 140, '10.00', '7.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '48.00', NULL, 'no', '2022-12-14 22:29:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2401, 'pre', 116, 140, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 11:59:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2402, 'pre', 117, 140, '10.00', '10.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 23:48:29', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2403, 'pre', 118, 140, '9.00', '9.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2404, 'pre', 119, 140, '10.00', '10.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 13:48:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2405, 'pre', 120, 140, '9.00', '9.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2406, 'pre', 121, 140, '10.00', '10.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2407, 'pre', 122, 140, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:21:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2408, 'pre', 110, 141, '10.00', '7.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2409, 'ABS', 111, 141, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2410, 'ABS', 112, 141, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 22:09:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2411, 'pre', 113, 141, '10.00', '8.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2412, 'pre', 114, 141, '9.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2413, 'ABS', 115, 141, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 22:29:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2414, 'pre', 116, 141, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 11:59:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2415, 'pre', 117, 141, '10.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2416, 'ABS', 118, 141, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2417, 'pre', 119, 141, '7.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 13:48:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2418, 'pre', 120, 141, '9.00', '9.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2419, 'pre', 121, 141, '10.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2420, 'pre', 122, 141, '7.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 15:21:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2421, 'pre', 110, 142, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 00:11:44', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2422, 'pre', 111, 142, '10.00', '8.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2423, 'pre', 112, 142, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 22:09:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2424, 'pre', 113, 142, '10.00', '10.00', '9.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 01:28:34', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2425, 'pre', 114, 142, '10.00', '7.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2426, 'pre', 115, 142, '4.00', '4.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '12.00', NULL, 'no', '2022-12-14 22:29:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2427, 'pre', 116, 142, '10.00', '6.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 11:59:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2428, 'pre', 117, 142, '10.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2429, 'pre', 118, 142, '8.00', '7.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2430, 'pre', 119, 142, '7.00', '7.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 13:48:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2431, 'pre', 120, 142, '8.00', '8.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2432, 'pre', 121, 142, '10.00', '10.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2433, 'pre', 122, 142, '10.00', '6.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:21:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2434, 'pre', 110, 143, '10.00', '10.00', '6.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2435, 'pre', 111, 143, '10.00', '8.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2436, 'pre', 112, 143, '8.00', '8.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-14 22:09:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2437, 'pre', 113, 143, '10.00', '10.00', '9.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 01:28:35', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2438, 'pre', 114, 143, '5.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2439, 'pre', 115, 143, '3.00', '3.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 22:29:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2440, 'pre', 116, 143, '10.00', '9.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 11:59:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2441, 'pre', 117, 143, '7.00', '5.00', '3.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2442, 'pre', 118, 143, '8.00', '8.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2443, 'pre', 119, 143, '6.00', '6.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 13:48:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2444, 'pre', 120, 143, '8.00', '7.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2445, 'pre', 121, 143, '10.00', '10.00', '9.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2446, 'pre', 122, 143, '6.00', '6.00', '6.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:21:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2447, 'pre', 110, 144, '10.00', '8.00', '7.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '26.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2448, 'pre', 111, 144, '8.00', '7.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '25.00', NULL, 'no', '2022-12-14 23:48:29', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2449, 'pre', 112, 144, '3.00', '3.00', '1.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '2.00', NULL, 'no', '2022-12-14 22:09:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2450, 'pre', 113, 144, '10.00', '10.00', '8.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 01:28:35', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2451, 'pre', 114, 144, '10.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2452, 'pre', 115, 144, '2.00', '2.00', '1.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '1.00', NULL, 'no', '2022-12-14 22:29:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2453, 'pre', 116, 144, '10.00', '8.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 11:59:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2454, 'pre', 117, 144, '10.00', '5.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2455, 'pre', 118, 144, '6.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2456, 'pre', 119, 144, '6.00', '4.00', '4.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 13:48:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2457, 'pre', 120, 144, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2458, 'pre', 121, 144, '10.00', '10.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '58.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2459, 'pre', 122, 144, '7.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '38.00', NULL, 'no', '2022-12-14 15:21:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2460, 'pre', 110, 145, '10.00', '9.00', '7.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2461, 'pre', 111, 145, '7.00', '7.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2462, 'pre', 112, 145, '5.00', '3.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '17.00', NULL, 'no', '2022-12-14 22:09:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2463, 'pre', 113, 145, '10.00', '10.00', '6.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '16.00', NULL, 'no', '2022-12-14 01:28:35', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2464, 'pre', 114, 145, '5.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2465, 'pre', 115, 145, '5.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '15.00', NULL, 'no', '2022-12-14 22:29:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2466, 'pre', 116, 145, '5.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '49.00', NULL, 'no', '2022-12-14 11:59:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2467, 'pre', 117, 145, '5.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '19.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2468, 'pre', 118, 145, '6.00', '4.00', '4.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2469, 'pre', 119, 145, '7.00', '6.00', '5.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 13:48:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2470, 'pre', 120, 145, '8.00', '5.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '24.00', NULL, 'no', '2022-12-19 00:26:38', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2471, 'pre', 121, 145, '10.00', '10.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2472, 'pre', 122, 145, '6.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 15:21:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2473, 'ABS', 110, 146, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2474, 'ABS', 111, 146, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2475, 'ABS', 112, 146, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2476, 'ABS', 113, 146, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2477, 'ABS', 114, 146, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2478, 'ABS', 115, 146, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2479, 'ABS', 116, 146, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2480, 'ABS', 117, 146, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2481, 'ABS', 118, 146, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2482, 'ABS', 119, 146, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2483, 'ABS', 120, 146, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2484, 'ABS', 121, 146, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2485, 'ABS', 122, 146, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2486, 'pre', 110, 147, '10.00', '10.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '14.00', NULL, 'no', '2022-12-14 22:09:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2487, 'pre', 111, 147, '10.00', '8.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2488, 'pre', 112, 147, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '5.00', NULL, 'no', '2022-12-14 22:09:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2489, 'pre', 113, 147, '10.00', '9.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 01:28:35', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2490, 'pre', 114, 147, '5.00', '5.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2491, 'pre', 115, 147, '4.00', '4.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '24.00', NULL, 'no', '2022-12-14 22:29:42', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2492, 'pre', 116, 147, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 11:59:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2493, 'pre', 117, 147, '10.00', '5.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2494, 'pre', 118, 147, '6.00', '6.00', '6.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2495, 'pre', 119, 147, '8.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 13:48:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2496, 'pre', 120, 147, '8.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2497, 'pre', 121, 147, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2498, 'pre', 122, 147, '10.00', '10.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 15:21:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2499, 'pre', 110, 148, '10.00', '10.00', '7.00', '1.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2500, 'pre', 111, 148, '9.00', '8.00', '5.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 00:32:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2501, 'pre', 112, 148, '8.00', '8.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 22:09:13', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2502, 'pre', 113, 148, '10.00', '10.00', '8.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 01:28:35', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2503, 'pre', 114, 148, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '30.00', NULL, 'no', '2022-12-14 02:08:40', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2504, 'pre', 115, 148, '2.00', '2.00', '2.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '6.00', NULL, 'no', '2022-12-14 23:48:29', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2505, 'pre', 116, 148, '10.00', '5.00', '3.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-14 11:59:20', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2506, 'pre', 117, 148, '10.00', '3.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-14 15:45:49', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2507, 'pre', 118, 148, '7.00', '7.00', '5.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-14 12:37:05', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2508, 'pre', 119, 148, '7.00', '7.00', '8.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-14 13:48:28', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2509, 'pre', 120, 148, '8.00', '6.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '35.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2510, 'pre', 121, 148, '10.00', '10.00', '10.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2511, 'pre', 122, 148, '10.00', '10.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '37.00', NULL, 'no', '2022-12-14 15:21:26', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2512, 'ABS', 110, 116, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2513, 'ABS', 111, 116, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2514, 'ABS', 112, 116, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2515, 'ABS', 113, 116, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2516, 'ABS', 114, 116, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2517, 'ABS', 115, 116, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2518, 'ABS', 116, 116, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2519, 'ABS', 117, 116, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2520, 'ABS', 118, 116, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2521, 'ABS', 119, 116, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 00:11:45', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2522, 'ABS', 120, 116, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2523, 'ABS', 121, 116, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2524, 'ABS', 122, 116, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 14:46:04', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2525, 'pre', 150, 150, '4.00', '5.00', '6.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 23:48:18', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2526, 'pre', 150, 311, '8.00', '5.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 23:48:18', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2527, 'pre', 150, 164, '10.00', '5.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '46.00', NULL, 'no', '2022-12-14 23:48:18', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2528, 'pre', 150, 167, '6.00', '6.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '36.00', NULL, 'no', '2022-12-14 23:48:18', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2529, 'pre', 150, 175, '10.00', '7.00', '8.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '58.00', NULL, 'no', '2022-12-14 23:48:18', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2530, 'pre', 150, 181, '4.00', '5.00', '5.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-14 23:48:18', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2531, 'pre', 150, 208, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-14 23:48:18', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2532, 'pre', 123, 295, '10.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '58.00', NULL, 'no', '2022-12-15 06:02:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2533, 'pre', 124, 295, '10.00', '10.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2534, 'pre', 125, 295, '7.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '52.00', NULL, 'no', '2022-12-15 06:02:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2535, 'pre', 126, 295, '10.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-15 06:02:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2536, 'pre', 127, 295, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2537, 'pre', 128, 295, '10.00', '10.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '56.00', NULL, 'no', '2022-12-15 00:29:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2538, 'pre', 129, 295, '10.00', '10.00', '10.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-15 00:29:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2539, 'pre', 130, 295, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '54.00', NULL, 'no', '2022-12-15 00:29:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2540, 'pre', 131, 295, '9.00', '9.00', '7.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '60.00', NULL, 'no', '2022-12-15 00:11:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2541, 'pre', 132, 295, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-15 00:11:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2542, 'pre', 133, 295, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2543, 'pre', 134, 295, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2544, 'pre', 135, 295, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2545, 'pre', 136, 295, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2546, 'pre', 137, 295, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2547, 'pre', 123, 300, '9.00', '7.00', '7.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '39.00', NULL, 'no', '2022-12-15 06:02:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2548, 'pre', 124, 300, '8.00', '8.00', '7.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '47.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2549, 'pre', 125, 300, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2550, 'pre', 126, 300, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '1.00', NULL, 'no', '2022-12-15 06:02:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2551, 'pre', 127, 300, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2552, 'pre', 128, 300, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2553, 'pre', 129, 300, '10.00', '10.00', '10.00', '3.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-15 00:29:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2554, 'pre', 130, 300, '10.00', '10.00', '10.00', '9.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-15 00:29:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2555, 'pre', 131, 300, '10.00', '9.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '50.00', NULL, 'no', '2022-12-15 00:11:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2556, 'pre', 132, 300, '10.00', '10.00', '10.00', '7.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-15 00:11:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2557, 'pre', 133, 300, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2558, 'pre', 134, 300, '10.00', '6.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '40.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2559, 'pre', 135, 300, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '54.00', NULL, 'no', '2022-12-15 00:29:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2560, 'pre', 136, 300, '10.00', '10.00', '10.00', '10.00', '0.00', '0.00', '0.00', '0.00', '0.00', '55.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2561, 'pre', 137, 300, '10.00', '7.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '45.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2562, 'pre', 123, 301, '2.00', '8.00', '8.00', '8.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-15 06:02:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2563, 'pre', 124, 301, '4.00', '4.00', '4.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '18.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2564, 'pre', 125, 301, '3.00', '2.00', '3.00', '2.00', '0.00', '0.00', '0.00', '0.00', '0.00', '6.00', NULL, 'no', '2022-12-15 06:02:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2565, 'pre', 126, 301, '1.00', '6.00', '6.00', '6.00', '0.00', '0.00', '0.00', '0.00', '0.00', '10.00', NULL, 'no', '2022-12-15 06:02:54', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2566, 'pre', 127, 301, '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', NULL, 'no', '2022-12-15 00:01:32', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2567, 'pre', 128, 301, '7.00', '6.00', '6.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-15 00:29:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2568, 'pre', 129, 301, '5.00', '5.00', '5.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '31.00', NULL, 'no', '2022-12-15 00:29:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2569, 'pre', 130, 301, '10.00', '8.00', '7.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-15 00:29:59', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2570, 'pre', 131, 301, '4.00', '4.00', '3.00', '4.00', '0.00', '0.00', '0.00', '0.00', '0.00', '20.00', NULL, 'no', '2022-12-15 00:11:16', '0000-00-00 00:00:00');
INSERT INTO `exam_results` (`id`, `attendence`, `exam_schedule_id`, `student_id`, `ca1`, `ca2`, `ca3`, `ca4`, `ca5`, `ca6`, `ca7`, `ca8`, `ca9`, `get_marks`, `note`, `is_active`, `created_at`, `updated_at`) VALUES (2571, 'pre', 132, 301, '10.00', '10.00', '9.00', '5.00', '0.00', '0.00', '0.00', '0.00', '0.00', '22.00', NULL, 'no', '2022-12-15 00:11:16', '0000-00-00 00:00:00');
INSERT INTO `exam_