<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Mark extends Admin_Controller {

    function __construct() {
        parent::__construct();

        $this->load->library('smsgateway');
        $this->load->library('mailsmsconf');
        $this->load->model("classteacher_model");
		$this->load->model('examresultscharacter_model');
    }

    function index() {
        // if(!$this->rbac->hasPrivilege('marks_register','can_view')){
        // access_denied();
        // }
        $this->session->set_userdata('top_menu', 'Examinations');
        $this->session->set_userdata('sub_menu', 'mark/index');
        $session = $this->setting_model->getCurrentSession();
		$session_name = $this->setting_model->getCurrentSessionName();
		$setting = $this->setting_model->get(1);
		$data['setting'] = $setting;
        $data['session_name'] = $session_name;
        $data['current_session'] = $session;
        $data['title'] = 'Exam Marks';
        $data['exam_id'] = "";
        $data['class_id'] = "";
        $data['section_id'] = "";
        $exam = $this->exam_model->get();
        $class = $this->class_model->get();
        $data['examlist'] = $exam;
        $data['classlist'] = $class;
		$gradeList = $this->grade_model->get();
        $data['gradeList'] = $gradeList;
        $userdata = $this->customlib->getUserData();
        //   if(($userdata["role_id"] == 2) && ($userdata["class_teacher"] == "yes")){
        // $data["classlist"] =   $this->customlib->getClassbyteacher($userdata["id"]);
        //     }
        $feecategory = $this->feecategory_model->get();
        $data['feecategorylist'] = $feecategory;
        $this->form_validation->set_rules('exam_id', 'Exam', 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', 'Class', 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', 'Section', 'trim|required|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/mark/markList', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $feecategory_id = $this->input->post('feecategory_id');
            $exam_id = $this->input->post('exam_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $data['exam_id'] = $exam_id;
            $data['class_id'] = $class_id;
            $data['section_id'] = $section_id;
									
			$this_class = $this->class_model->get($class_id);
			$this_section = $this->section_model->get($section_id);
						
			$class_name = $this_class['class'];
			$section_name = $this_section['section'];
			
			$data['class_name'] = $class_name;
            $data['section_name'] = $section_name;
			         
            $examSchedule = $this->examschedule_model->getDetailbyClsandSection($class_id, $section_id, $exam_id);
            $studentList = $this->student_model->searchByClassSection($class_id, $section_id);			
			//sections/getByClass
            $className = $this->section_model->getClassNameBySection($class_id, $section_id);
			
            $data['examSchedule'] = array();
            if (!empty($examSchedule)) {
                $new_array = array();
                $data['examSchedule']['status'] = "yes";
                foreach ($studentList as $stu_key => $stu_value) {
                    $array = array();
                    $array['student_id'] = $stu_value['id'];
					$student_id_x = $stu_value['id'];
					////STUDENT CURRENT RECORD
					$studentCurrentDetails = $this->student_model->getRecentRecord($student_id_x);
					$array['current_details'] = $studentCurrentDetails ;					
					////END STUDENT CURRENT RECORD
                    $array['roll_no'] = $stu_value['roll_no'];
                    $array['firstname'] = $stu_value['firstname'];
                    $array['lastname'] = $stu_value['lastname'];
					$array['gender'] = $stu_value['gender'];
                    $array['admission_no'] = $stu_value['admission_no'];
                    $array['dob'] = $stu_value['dob'];
                    $array['father_name'] = $stu_value['father_name'];
					$array['session_name'] = $session_name;
					$array['character'] = array();
					$this_character = $this->examresultscharacter_model->get_character($session,$exam_id,$stu_value['id']);
					if(is_array($this_character))
					{
					$array['character'] = $this_character;
					}
                    $x = array();
                    foreach ($examSchedule as $ex_key => $ex_value) {
                        $exam_array = array();
                        $exam_array['exam_schedule_id'] = $ex_value['id'];
                        $exam_array['exam_id'] = $ex_value['exam_id'];
                        $exam_array['full_marks'] = $ex_value['full_marks'];
                        $exam_array['passing_marks'] = $ex_value['passing_marks'];
                        $exam_array['exam_name'] = $ex_value['name'];
                        $exam_array['exam_type'] = $ex_value['type'];
                        $student_exam_result = $this->examresult_model->get_result($ex_value['id'], $stu_value['id']);

                        if (empty($student_exam_result)) {
                            
                        } else {
                            $exam_array['attendence'] = $student_exam_result->attendence;
                            $exam_array['get_marks'] = $student_exam_result->get_marks;
							$exam_array['ca1'] = $student_exam_result->ca1;
                            $exam_array['ca2'] = $student_exam_result->ca2;
                            $exam_array['ca3'] = $student_exam_result->ca3;
                            $exam_array['ca4'] = $student_exam_result->ca4;
                            $exam_array['ca5'] = $student_exam_result->ca5;
                            $exam_array['ca6'] = $student_exam_result->ca6;
                            $exam_array['ca7'] = $student_exam_result->ca7;
                            $exam_array['ca8'] = $student_exam_result->ca8;
                            $exam_array['ca9'] = $student_exam_result->ca9;
                        }
                        $x[] = $exam_array;
                    }
                    if (empty($x)) {
                        $data['examSchedule']['status'] = "no";
                    }
                    $array['exam_array'] = $x;
                    $new_array[] = $array;
                }
				
				$student_id_x = "undefined";

                $data['examSchedule']['result'] = $new_array;
            } else {
                $s = array('status' => 'no');
                $data['examSchedule'] = $s;
            }
			
						///GET ALL EXAMS
			$all_exams_get = $this->exam_model->get();
			$data['all_exams_get'] = $all_exams_get;			
			$ea = array();
			$annual_result = array();
			foreach($all_exams_get as $each_exam => $exam_data){
				
			$exam_id_each = $exam_data['id'];
            $examSchedule = $this->examschedule_model->getDetailbyClsandSection($class_id, $section_id, $exam_id_each);
            $studentList = $this->student_model->searchByClassSection($class_id, $section_id);
			//sections/getByClass
            $className = $this->section_model->getClassNameBySection($class_id, $section_id);
			
           // $data['examSchedule'] = array();
            if (!empty($examSchedule)) {
                $new_array = array();
             //   $data['examSchedule']['status'] = "yes";
                foreach ($studentList as $stu_key => $stu_value) {
                    $array = array();
                    $array['student_id'] = $stu_value['id'];
					$student_id_x = $stu_value['id'];
					////STUDENT CORRECT RECORD
					$studentCurrentDetails = $this->student_model->getRecentRecord($student_id_x);
					$array['current_details'] = $studentCurrentDetails ;					
					////END STUDENT CORRECT RECORD
                    $array['roll_no'] = $stu_value['roll_no'];
                    $array['firstname'] = $stu_value['firstname'];
                    $array['lastname'] = $stu_value['lastname'];
                    $array['gender'] = $stu_value['gender'];
                    $array['admission_no'] = $stu_value['admission_no'];
                    $array['dob'] = $stu_value['dob'];
                    $array['father_name'] = $stu_value['father_name'];
					$array['character'] = array();
					$this_character = $this->examresultscharacter_model->get_character($session,$exam_id,$stu_value['id']);
					if(is_array($this_character))
					{
					$array['character'] = $this_character;
					}
                    $x = array();
                    foreach ($examSchedule as $ex_key => $ex_value) {
                        $exam_array = array();
                        $exam_array['exam_schedule_id'] = $ex_value['id'];
                        $exam_array['exam_id'] = $ex_value['exam_id'];
                        $exam_array['full_marks'] = $ex_value['full_marks'];
                        $exam_array['passing_marks'] = $ex_value['passing_marks'];
                        $exam_array['exam_name'] = $ex_value['name'];
                        $exam_array['exam_type'] = $ex_value['type'];
                        $student_exam_result = $this->examresult_model->get_result($ex_value['id'], $stu_value['id']);

                        if (empty($student_exam_result)) {
                            
                        } else {
                            $exam_array['attendence'] = $student_exam_result->attendence;
                            $exam_array['get_marks'] = $student_exam_result->get_marks;
							$exam_array['ca1'] = $student_exam_result->ca1;
                            $exam_array['ca2'] = $student_exam_result->ca2;
                            $exam_array['ca3'] = $student_exam_result->ca3;
                            $exam_array['ca4'] = $student_exam_result->ca4;
                            $exam_array['ca5'] = $student_exam_result->ca5;
                            $exam_array['ca6'] = $student_exam_result->ca6;
                            $exam_array['ca7'] = $student_exam_result->ca7;
                            $exam_array['ca8'] = $student_exam_result->ca8;
                            $exam_array['ca9'] = $student_exam_result->ca9;
                        }
                        $x[] = $exam_array;
                    }
                    if (empty($x)) {
                //        $data['examSchedule']['status'] = "no";
                    }
                    $array['exam_array'] = $x;
                    $new_array[] = $array;
                }
				
				$student_id_x = "undefined";
				
				

             //   $data['examSchedule']['result'] = $new_array;
                $annual_result[] = $new_array;
            } else {
                $s = array('status' => 'no');
            //    $data['examSchedule'] = $s;
            }
			}
			
		$data['annual_result'] = $annual_result;
		
		$examSchedule = array();
		///END GET ALL EXAMS
            $this->load->view('layout/header', $data);
            $this->load->view('admin/mark/markList', $data);
            $this->load->view('layout/footer', $data);
        }
    }

    function view($id) {
        if (!$this->rbac->hasPrivilege('marks_register', 'can_view')) {
            access_denied();
        }
        $data['title'] = 'Mark List';
        $mark = $this->mark_model->get($id);
        $data['mark'] = $mark;
        $this->load->view('layout/header', $data);
        $this->load->view('admin/mark/markShow', $data);
        $this->load->view('layout/footer', $data);
    }

    function delete($id) {
        $data['title'] = 'Mark List';
        $this->mark_model->remove($id);
        redirect('admin/mark/index');
    }

    function create() {
        // if(!$this->rbac->hasPrivilege('marks_register','can_add')){
        // access_denied();
        // }
        $session = $this->setting_model->getCurrentSession();
        $data['title'] = 'Exam Schedule';
        $data['exam_id'] = "";
        $data['class_id'] = "";
        $data['section_id'] = "";
        $exam = $this->exam_model->get();
		$character = $this->examresultscharacter_model->get();
		$data['character'] = $character;
        $class = $this->class_model->get();
        $data['examlist'] = $exam;
        $data['classlist'] = $class;
        $userdata = $this->customlib->getUserData();
        //   if(($userdata["role_id"] == 2) && ($userdata["class_teacher"] == "yes")){
        //  $data["classlist"] =   $this->customlib->getclassbyteacher($userdata["id"]);
        // } 
        $feecategory = $this->feecategory_model->get();
        $data['feecategorylist'] = $feecategory;
        $this->form_validation->set_rules('exam_id', 'Exam', 'trim|required|xss_clean');
        $this->form_validation->set_rules('class_id', 'Class', 'trim|required|xss_clean');
        $this->form_validation->set_rules('section_id', 'Section', 'trim|required|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/mark/markCreate', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $feecategory_id = $this->input->post('feecategory_id');
            $exam_id = $this->input->post('exam_id');
            $class_id = $this->input->post('class_id');
            $section_id = $this->input->post('section_id');
            $data['exam_id'] = $exam_id;
            $data['class_id'] = $class_id;
            $data['section_id'] = $section_id;
            $userdata = $this->customlib->getUserData();
            $getTeacherSubjects = array();
            if (($userdata["role_id"] == 2) && ($userdata["class_teacher"] == "yes")) {
                $getTeacherSubjects = $this->examschedule_model->getTeacherSubjects($class_id, $section_id, $userdata["id"]);
            }
			
			/////
			$subject_data = $this->teachersubject_model->getSubjectByClsandSection($class_id, $section_id);	
			$data['subject_data'] = $subject_data;
			////
			
			$this_class = $this->class_model->get($class_id);
			$this_section = $this->section_model->get($section_id);
			
			$class_name = $this_class['class'];
			$section_name = $this_section['section'];
			
			$data['class_name'] = $class_name;
            $data['section_name'] = $section_name;
			
            $data["teacher_subjects"] = $getTeacherSubjects;
            $examSchedule = $this->examschedule_model->getDetailbyClsandSection($class_id, $section_id, $exam_id);

            $studentList = $this->student_model->searchByClassSection($class_id, $section_id);

            if (!empty($examSchedule)) {
                $new_array = array();
                foreach ($studentList as $stu_key => $stu_value) {
                    $array = array();
                    $array['student_id'] = $stu_value['id'];
                    $array['admission_no'] = $stu_value['admission_no'];
                    $array['roll_no'] = $stu_value['roll_no'];
                    $array['firstname'] = $stu_value['firstname'];
                    $array['lastname'] = $stu_value['lastname'];
					$array['gender'] = $stu_value['gender'];
                    $array['dob'] = $stu_value['dob'];
                    $array['father_name'] = $stu_value['father_name'];
					$array['character'] = array();
					$this_character = $this->examresultscharacter_model->get_character($session,$exam_id,$stu_value['id']);
					if(is_array($this_character))
					{
					$array['character'] = $this_character;
					}					
                    $x = array();
                    foreach ($examSchedule as $ex_key => $ex_value) {
                        $exam_array = array();
                        $exam_array['exam_schedule_id'] = $ex_value['id'];
                        $exam_array['exam_id'] = $ex_value['exam_id'];
						$exam_array['teacher_subject_id'] = $ex_value['teacher_subject_id'];
                        $exam_array['subject_id'] = $ex_value['subject_id'];
                        $exam_array['full_marks'] = $ex_value['full_marks'];
                        $exam_array['passing_marks'] = $ex_value['passing_marks'];
                        $exam_array['exam_name'] = $ex_value['name'];
                        $exam_array['exam_type'] = $ex_value['type'];
                        $student_exam_result = $this->examresult_model->get_exam_result($ex_value['id'], $stu_value['id']);
                        $exam_array['attendence'] = $student_exam_result->attendence;
                        $exam_array['get_marks'] = $student_exam_result->get_marks;
						
						$exam_array['ca1'] = $student_exam_result->ca1;
                        $exam_array['ca2'] = $student_exam_result->ca2;
                        $exam_array['ca3'] = $student_exam_result->ca3;
                        $exam_array['ca4'] = $student_exam_result->ca4;
                        $exam_array['ca5'] = $student_exam_result->ca5;
                        $exam_array['ca6'] = $student_exam_result->ca6;
                        $exam_array['ca7'] = $student_exam_result->ca7;
                        $exam_array['ca8'] = $student_exam_result->ca8;
                        $exam_array['ca9'] = $student_exam_result->ca9;
						
						
						
                        $x[] = $exam_array;
                    }
                    $array['exam_array'] = $x;
                    $new_array[] = $array;
                }
                $data['examSchedule'] = $new_array;
            }
            if ($this->input->post('save_exam') == "save_exam") {
                $ex_array = array();
                $exam_id = $this->input->post('exam_id');
                $student_array = $this->input->post('student');
                $exam_array = $this->input->post('exam_schedule');
                foreach ($student_array as $key => $student) {
                    foreach ($exam_array as $key => $exam) {
                        $record['get_marks'] = 0;
                        $record['ca1'] = 0;
                        $record['ca2'] = 0;
                        $record['ca3'] = 0;					
                        $record['ca4'] = 0;					
                        $record['ca5'] = 0;					
                        $record['ca6'] = 0;					
                        $record['ca7'] = 0;					
                        $record['ca8'] = 0;					
                        $record['ca9'] = 0;					
                        $record['attendence'] = "pre";
                        if ($this->input->post('student_absent' . $student . "_" . $exam) == "") {
                            $record['get_marks'] = $this->input->post('student_number' . $student . "_" . $exam);
                            $record['ca1'] = $this->input->post('student_number' . $student . "_" . $exam . "_ca1");
                            $record['ca2'] = $this->input->post('student_number' . $student . "_" . $exam . "_ca2");
                            $record['ca3'] = $this->input->post('student_number' . $student . "_" . $exam . "_ca3");
                            $record['ca4'] = $this->input->post('student_number' . $student . "_" . $exam . "_ca4");
                            $record['ca5'] = $this->input->post('student_number' . $student . "_" . $exam . "_ca5");
                            $record['ca6'] = $this->input->post('student_number' . $student . "_" . $exam . "_ca6");
                            $record['ca7'] = $this->input->post('student_number' . $student . "_" . $exam . "_ca7");
                            $record['ca8'] = $this->input->post('student_number' . $student . "_" . $exam . "_ca8");
                            $record['ca9'] = $this->input->post('student_number' . $student . "_" . $exam . "_ca9");
                        
						} else {
                            $record['attendence'] = $this->input->post('student_absent' . $student . "_" . $exam);
                        }
						
                        $record['exam_schedule_id'] = $exam;
                        $record['student_id'] = $student;																	
                        $inserted_id = $this->examresult_model->add_exam_result($record);

                        if ($inserted_id) {
                            $ex_array[$student] = $exam_id;
                        }
                    }
				$record2['session_id'] = $session;				
				$record2['exam_id'] = $exam_id;
                $record2['student_id'] = $student;				
				
				$record2['c1'] = $this->input->post('student_c_' . $student .  "_c1");
                $record2['c2'] = $this->input->post('student_c_' . $student  . "_c2");
                $record2['c3'] = $this->input->post('student_c_' . $student .  "_c3");				
				$record2['c4'] = $this->input->post('student_c_' . $student .  "_c4");				
                $record2['c5'] = $this->input->post('student_c_' . $student .  "_c5");				
                $record2['c6'] = $this->input->post('student_c_' . $student .  "_c6");					
                $record2['c7'] = $this->input->post('student_c_' . $student .  "_c7");					
                $record2['c8'] = $this->input->post('student_c_' . $student .  "_c8");					
                $record2['c9'] = $this->input->post('student_c_' . $student .  "_c9");					
                $record2['c10'] = $this->input->post('student_c_' . $student .  "_c10");					
                $record2['c11'] = $this->input->post('student_c_' . $student .  "_c11");					
                $record2['c12'] = $this->input->post('student_c_' . $student .  "_c12");					
                $record2['c13'] = $this->input->post('student_c_' . $student .  "_c13");					
                $record2['c14'] = $this->input->post('student_c_' . $student .  "_c14");					
                $record2['c15'] = $this->input->post('student_c_' . $student .  "_c15");					
                $record2['c16'] = $this->input->post('student_c_' . $student .  "_c16");					
                $record2['c17'] = $this->input->post('student_c_' . $student .  "_c17");					
                $record2['c18'] = $this->input->post('student_c_' . $student .  "_c18");					
                $record2['c19'] = $this->input->post('student_c_' . $student .  "_c19");					
                $record2['c20'] = $this->input->post('student_c_' . $student .  "_c20");					
                $record2['c21'] = $this->input->post('student_c_' . $student .  "_c21");					
                $record2['c22'] = $this->input->post('student_c_' . $student .  "_c22");					
                $record2['c23'] = $this->input->post('student_c_' . $student .  "_c23");					
                $record2['c24'] = $this->input->post('student_c_' . $student .  "_c24");					
	/*	*/		
			
				$inserted_id_c = $this->examresultscharacter_model->add_character($record2);					
																		
                }




                if (!empty($ex_array)) {
                    $this->mailsmsconf->mailsms('exam_result', $ex_array, NULL, $exam_array);
                }

                redirect('admin/mark');
            }

            $this->load->view('layout/header', $data);
            $this->load->view('admin/mark/markCreate', $data);
            $this->load->view('layout/footer', $data);
        }
    }

    function edit($id) {
        if (!$this->rbac->hasPrivilege('marks_register', 'can_edit')) {
            access_denied();
        }
        $data['title'] = 'Edit Mark';
        $data['id'] = $id;
        $mark = $this->mark_model->get($id);
        $data['mark'] = $mark;
        $this->form_validation->set_rules('name', 'Mark', 'trim|required|xss_clean');
        if ($this->form_validation->run() == FALSE) {
            $this->load->view('layout/header', $data);
            $this->load->view('admin/mark/markEdit', $data);
            $this->load->view('layout/footer', $data);
        } else {
            $data = array(
                'id' => $id,
                'name' => $this->input->post('name'),
                'note' => $this->input->post('note'),
            );
            $this->mark_model->add($data);
            $this->session->set_flashdata('msg', '<div mark="alert alert-success text-center">Employee details added to Database!!!</div>');
            redirect('admin/mark/index');
        }
    }

}

?>